﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    /// <summary>
    /// Represents a physical address, which may be a street address or a postal address, and may 
    /// be an Australian address or an international address.
    /// </summary>
    public class Address
    {
        #region Properties

        /// <summary>
        /// Gets or sets the NHSD URI for the contact purpose.
        /// </summary>
        public string ContactPurposeUri { get; set; }

        /// <summary>
        /// Gets or sets the Code for the contact purpose.
        /// </summary>
        public string ContactPurposeCode { get; set; }

        /// <summary>
        /// Gets or sets the DisplayName for the contact purpose.
        /// </summary>
        public string ContactPurposeDisplayName { get; set; }

        /// <summary>
        /// Gets or sets the flat type reference item display name.
        /// </summary>
        public string FlatType { get; set; }

        /// <summary>
        /// Gets or sets the unit number.
        /// </summary>
        public string FlatNumber { get; set; }

        /// <summary>
        /// Gets or sets the site name.
        /// </summary>
        public string AddressSiteName { get; set; }

        /// <summary>
        /// Gets or sets the level type.
        /// </summary>
        public string LevelType { get; set; }

        /// <summary>
        /// Gets or sets the level number.
        /// </summary>
        public string LevelNumber { get; set; }

        /// <summary>
        /// Gets or sets the street number.
        /// </summary>
        public string StreetNumber { get; set; }

        /// <summary>
        /// Gets or sets the lot number.
        /// </summary>
        public string LotNumber { get; set; }

        /// <summary>
        /// Gets or sets the street name.
        /// </summary>
        public string StreetName { get; set; }

        /// <summary>
        /// Gets or sets the street type.
        /// </summary>
        public string StreetType { get; set; }

        /// <summary>
        /// Gets or sets the street suffix.
        /// </summary>
        public string StreetSuffix { get; set; }

        /// <summary>
        /// Gets or sets the postal delivery type.
        /// </summary>
        public string PostalDeliveryType { get; set; }

        /// <summary>
        /// Gets or sets the postal delivery number.
        /// </summary>
        public string PostalDeliveryNumber { get; set; }

        /// <summary>
        /// Gets or sets the unstructured address line.
        /// </summary>
        public string UnstructuredAddressLine { get; set; }

        /// <summary>
        /// Gets or sets the suburb, town or locality.
        /// </summary>
        public string Suburb { get; set; }

        /// <summary>
        /// Gets or sets the state or territory.
        /// </summary>
        public string State { get; set; }

        /// <summary>
        /// Gets or sets the postcode.
        /// </summary>
        public string Postcode { get; set; }

        /// <summary>
        /// Gets or sets the geocoded latitude in degrees.
        /// </summary>
        public double Latitude { get; set; }

        /// <summary>
        /// Gets or sets the geocoded longitude in degrees.
        /// </summary>
        public double Longitude { get; set; }

        /// <summary>
        /// Gets or sets the PO Box description.
        /// </summary>
        public int Elevation { get; set; }

        #endregion
    }
}
