﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class DocumentChannelPreference
    {
        #region Properties

        /// <summary>
        /// Gets or sets the document channel preference ID from NEPS.
        /// </summary>        
        public string DocumentChannelPreferenceId { get; set; }

        /// <summary>
        /// Gets or sets the primary identifier of the target provider organisation.
        /// </summary>        
        public string OrganisationId { get; set; }

        /// <summary>
        /// Gets or sets the primary identifier of the target provider location.
        /// </summary>        
        public string LocationId { get; set; }

        /// <summary>
        /// Gets or sets the NHSD URI for the document type that this record expresses a preference for delivery of.
        /// </summary>        
        public string DocumentTypeUri { get; set; }

        /// <summary>
        /// Gets or sets the NHSD Root OID for the document type code.
        /// </summary>        
        public string DocumentTypeOid { get; set; }

        /// <summary>
        /// Gets or sets the code for the document type.
        /// </summary>        
        public string DocumentTypeCode { get; set; }

        /// <summary>
        /// Gets or sets the Display Name for the document type.
        /// </summary>        
        public string DocumentTypeDisplayName { get; set; }

        /// <summary>
        /// Gets or sets the list of channels by which the provider location can accept this document type.
        /// Examples are SMD, Email, Proprietary, Fax or Post.
        /// </summary>        
        public List<ChannelType> ChannelTypes { get; set; }

        #endregion
    }
}
