﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.ServiceContracts.Hpii.Message;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Model.Hpii;

namespace HIPS.Web.ModelInterface.HpiiSearch
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of Hpii Search Service (v2).
    /// </summary>
    public interface IHpiiSearchServiceV2
    {
        /// <summary>
        /// List all of the current local providers for the specified facility.
        /// </summary>
        /// <param name="hospitalCode">Hospital Code.</param>
        /// <param name="hospitalCodeSystem">Hospital Code System.</param>
        /// <param name="user">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<List<LocalProvider>> ListLocalProviders(string hospitalCode, string hospitalCodeSystem, Model.Identity.LocalUser user);

        /// <summary>
        /// Add or Edit a Local Provider.
        /// </summary>
        /// <param name="hospitalCode">Hospital Code.</param>
        /// <param name="hospitalCodeSystem">Hospital Code System.</param>
        /// <param name="hpii">Hpii.</param>
        /// <param name="title">Title.</param>
        /// <param name="familyName">Family Name.</param>
        /// <param name="givenNames">Given Names.</param>
        /// <param name="suffix">Suffix.</param>
        /// <param name="user">User context within which the service is accessed.</param>
        /// <param name="iamProviderIdentifier">Iam Provider Identifier</param>
        /// <param name="localProviderCode">Local Provider Code.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<AddEditLocalProviderResponse> AddEditLocalProvider(string hospitalCode, string hospitalCodeSystem, string hpii, string title, string familyName, string givenNames, string suffix, Model.Identity.LocalUser user, string iamProviderIdentifier = null, string localProviderCode = null);

        /// <summary>
        /// Add or Replace a Local Provider Identifier.
        /// </summary>
        /// <param name="localProviderIdentifier">Local Provider Identifier.</param>
        /// <param name="replace">A value indicating whether the Local Provider Identifier will be replaced.</param>
        /// <param name="user">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<AddReplaceLocalProviderIdentifierResponse> AddReplaceLocalProviderIdentifier(LocalProviderIdentifier localProviderIdentifier, bool replace, Model.Identity.LocalUser user);

        /// <summary>
        /// Deactivates or removes deactivation a local provider.
        /// </summary>
        /// <param name="hospitalCode">Hospital Code.</param>
        /// <param name="hospitalCodeSystem">Hospital Code System.</param>
        /// <param name="localProviderCode">Local Provider Code.</param>
        /// <param name="deactivatedDate">Deactivated Date.</param>
        /// <param name="user">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>
        ServiceResponse<DeactivateLocalProviderResponse> DeactivateLocalProvider(string hospitalCode, string hospitalCodeSystem, string localProviderCode, DateTime? deactivatedDate, Model.Identity.LocalUser user);
    }
}
