﻿using System;
using System.Collections.Generic;

using HIPS.Web.Components.ServiceModel;
using HIPS.Web.Model.Identity;
using HIPS.Web.Model.Messaging;

namespace HIPS.Web.ModelInterface.Messaging
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a Message Delivery Service.
    /// </summary>
    public interface IMessageDeliveryService
    {
        #region Methods

        /// <summary>
        /// Returns a list of outbound sealed messages.
        /// </summary>
        /// <param name="sender">Sender of the outbound sealed message to be return.</param>
        /// <param name="receiver">Receiver of the outbound sealed message to be return.</param>
        /// <param name="deliveryPeriod">Start/End of the outbound sealed message to be return.</param>
        /// <param name="messageStatusId">Message status Id of outbound sealed message to be return.</param>        
        /// <param name="documentType">Document type of the outbound sealed message to be return.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>        
        ServiceResponse<List<OutboundSealedMessage>> QueryMessages(MessageAddressee sender, MessageAddressee receiver, DateTimeRange deliveryPeriod, int? messageStatusId, string documentType, LocalUser userContext, int recordLimit, int recordSkipFrom);
        
        /// <summary>
        /// Aborts a specified outbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the outbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>        
        ServiceResponse<object> AbortMessage(string invocationIdentifier, LocalUser userContext);
        
        /// <summary>
        /// Retries a specified outbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the outbound message.</param>
        /// <param name="expiryDate">Sets a new expiry date for the outbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>        
        ServiceResponse<object> RetryMessage(string invocationIdentifier, DateTime expiryDate, LocalUser userContext);
        
        /// <summary>
        /// Downloads the message content of the specified outbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the outbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>        
        ServiceResponse<BinaryMessageContent> GetMessage(string invocationIdentifier, LocalUser userContext);
        
        /// <summary>
        /// Downloads the CDA message content of the specified outbound message.
        /// </summary>
        /// <param name="invocationIdentifier">Identifier of the outbound message.</param>
        /// <param name="userContext">User context within which the service is accessed.</param>
        /// <returns>A ServiceResponse object.</returns>        
        ServiceResponse<CdaMessageContent> GetCdaMessage(string invocationIdentifier, LocalUser userContext);

        #endregion
    }
}
