﻿using System.Collections.Generic;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Directory.ViewModels
{
    /// <summary>
    /// Delegate list view model.
    /// </summary>
    public class ListDelegatesViewModel : DirectoryViewModelBase
    {

        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="ListDelegatesViewModel"/> class.
        /// </summary>
        public ListDelegatesViewModel()
            : base()
        {
            this.Delegates = new List<HIPS.Web.Model.Directory.Delegate>();
            this.Intermediaries = new List<HIPS.Web.Model.Directory.Intermediary>();
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets or sets the list of delegates.
        /// </summary>
        public List<HIPS.Web.Model.Directory.Delegate> Delegates { get; set; }

        /// <summary>
        /// Gets or sets the list of intermediaries.
        /// </summary>
        public List<HIPS.Web.Model.Directory.Intermediary> Intermediaries { get; set; }

        #endregion

    }
}