﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HIPS.Web.UI.Areas.Directory.ViewModels
{
    /// <summary>
    /// Reprioritise delegate view model.
    /// </summary>
    public class ReprioritiseDelegateViewModel : DirectoryViewModelBase
    {

        #region Properties

        /// <summary>
        /// Gets or sets the ID of the delegate to reprioritise.
        /// </summary>
        [Required]
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets the from position of the delegate to reprioritise.
        /// </summary>
        [Required]
        public int FromPosition { get; set; }

        /// <summary>
        /// Gets or sets the to position of the delegate to reprioritise.
        /// </summary>
        [Required]
        public int ToPosition { get; set; }

        #endregion

    }
}