﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

using HIPS.Web.Model;
using HIPS.Web.Model.Messaging;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Messaging.ViewModels
{
    /// <summary>
    /// View model for displaying the result when searching outbound sealed messages.
    /// </summary>    
    public class ListDeliveryViewModel
    {
        /// <summary>
        /// Gets or sets the Invocation Identifier.
        /// </summary>
        [Display(Name = "Invocation Identifier")]
        public string InvocationIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the Message Timestamp.
        /// </summary>
        [Display(Name = "Sent")]
        public DateTime MessageTimestamp { get; set; }

        /// <summary>
        /// Gets or sets the Receiver.
        /// </summary>
        [Display(Name = "Receiver HPI-O")]
        public string Receiver { get; set; }

        /// <summary>
        /// Gets or sets the Document Type.
        /// </summary>
        [Display(Name = "Document Type")]
        public string DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the Message Status.
        /// </summary>
        [Display(Name = "Message Status")]
        public OutboundMessageStatus MessageStatus { get; set; }

        /// <summary>
        /// Gets the Message Status as text.
        /// </summary>
        [Display(Name = "Message Status")]
        public string MessageStatusText
        {
            get
            {
                if (this.MessageStatus == HIPS.Web.Model.OutboundMessageStatus.UndeliveredExpired)
                {
                    return "Undelivered - Expired";
                }
                else if (this.MessageStatus == HIPS.Web.Model.OutboundMessageStatus.ExceedRetryCount)
                {
                    return "Exceeded Retry Count";
                }
                else
                {
                    return this.MessageStatus.ToString();
                }
            }
        }

        /// <summary>
        /// Gets or sets additional details.
        /// </summary>
        public DetailsViewModel Details { get; set; }
    }
}