﻿using System.Web.Mvc;

namespace HIPS.Web.UI.Areas.Subscription
{
    public class SubscriptionAreaRegistration : AreaRegistration
    {
        #region Properties

        /// <summary>
        /// Gets the name of the area.
        /// </summary>
        public override string AreaName
        {
            get
            {
                return "Subscription";
            }
        }

        #endregion

        #region Methods

        /// <summary>
        /// Register the area.
        /// </summary>
        /// <param name="context">AreaRegistrationContext to use for registration of the area.</param>
        public override void RegisterArea(AreaRegistrationContext context)
        {
            context.MapRoute(
                "SubscriptionDefault",
                "Subscription/{action}/{id}",
                new {controller = "Subscription", action = "AreasOfInterest", id = UrlParameter.Optional });
        }

        #endregion
    }
}