﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Subscription.ViewModels
{
    public class AreaOfInterestViewModel
    {
        #region Properties

        /// <summary>
        /// Gets or sets the URI allocated by NEPS to identify this area of interest definition.
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the description of the area of interest.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the URI allocated by NEPS to identify this area of interest definition.
        /// </summary>
        public List<GeographicalAreaViewModel> Areas { get; set; }

        /// <summary>
        /// Gets or sets the Lists of Occupations
        /// </summary>
        public List<IndividualOccupationViewModel> Occupations { get; set; }

        /// <summary>
        /// Gets or sets the Lists of Classifications
        /// </summary>
        public List<OrganisationClassificationViewModel> Classifications { get; set; }

        /// <summary>
        /// Gets or sets the list of Extra Individual Search Model
        /// </summary>
        public ExtraIndividualSearchViewModel Individuals { get; set; }

        /// <summary>
        /// Gets or sets the list of Extra Organisation Search Model
        /// </summary>
        public ExtraOrganisationSearchViewModel Organisations { get; set; }

        /// <summary>
        /// Gets or sets the list of Extra Individuals returned from the search
        /// </summary>
        public List<ExtraIndividualViewModel> ExtraIndividual { get; set; }

        /// <summary>
        /// Gets or sets the list of Extra Organisations returned from the search
        /// </summary>
        public List<ExtraOrganisationViewModel> ExtraOrganisation { get; set; }

        /// <summary>
        /// Gets or sets if the modal is in Edit Mode or not
        /// </summary>
        public bool isEdit { get; set; }

        /// <summary>
        /// Gets or sets the Filter for Geographical Area.
        /// </summary>
        [Display(Name = "Show")]
        public string Filter { get; set; }

        /// <summary>
        /// Gets or sets the FilterGeographicalArea List for the dropdown.
        /// </summary>
        public IEnumerable<SelectListItem> FilterList { get; set; }

        #endregion
    }
}
