﻿using System;
using System.Web.Mvc;

namespace HIPS.Web.UI.Controllers
{
    /// <summary>
    /// Controller for the error page.
    /// </summary>
    public class ErrorController : Controller
    {
        /// <summary>
        /// Default error page.
        /// </summary>
        /// <returns>View result.</returns>
        public ActionResult Index()
        {
            Response.StatusCode = 500;
            return this.View();
        }

        /// <summary>
        /// Unauthorised error page.
        /// </summary>
        /// <returns>View result.</returns>
        public ActionResult Unauthorized()
        {
            // Response.StatusCode = 401; // Returning a 401 status seems to cause issues in IE with windows auth
            return this.View();
        }

        /// <summary>
        /// Forbidden error page.
        /// </summary>
        /// <returns>View result.</returns>
        public ActionResult Forbidden()
        {
            Response.StatusCode = 403;
            return this.View();
        }

        /// <summary>
        /// Not found error page.
        /// </summary>
        /// <returns>View result.</returns>
        public ActionResult NotFound()
        {
            Response.StatusCode = 404; // TODO: Possibly don't render views for asset requests (not text/html, plain, JSON)
            return this.View();
        }

        /// <summary>
        /// HttpRequestValidationException error page.
        /// </summary>
        /// <returns>Error page.</returns>

        public ActionResult HttpRequestValidationException(Exception exception)
        {
            this.View().ViewBag.Error = exception.Message;
            return this.View();
        }

        /// <summary>
        /// EndpointNotFoundException error page.
        /// </summary>
        /// <returns>Error page.</returns>

        public ActionResult EndpointNotFoundException(Exception exception)
        {
            this.View().ViewBag.Error = exception.Message;
            return this.View();
        }
    }
}
