﻿using HIPS.HpiiSchemas;
using HIPS.Web.Components.Common;
using HIPS.Web.UI.ViewModels.HpiiSearch;
using nehta.mcaR50.ProviderSearchForProviderIndividual;

namespace HIPS.Web.UI.Conversion.HpiiSearch
{
    public static class InternationalAddressViewModelExtensions
    {
        /// <summary>
        /// Loads an international address into the view model. 
        /// </summary>
        /// <param name="viewModel">The view model to load data into.</param>
        /// <param name="address">The address to load.</param>
        /// <returns>The view model.</returns>
        public static InternationalAddressViewModel LoadFromInternationalAddress(this InternationalAddressViewModel viewModel, InternationalAddress address)
        {
            viewModel.InternationalAddressLine = address.InternationalAddressLine;
            viewModel.InternationalStateProvince = address.InternationalStateProvince;
            viewModel.InternationalPostcode = address.InternationalPostcode;
            viewModel.CountryCode = address.Country.HasValue ? address.Country.Value.ToString() : string.Empty;
            if (viewModel.CountryCode.StartsWith("Item"))
            {
                viewModel.CountryCode = viewModel.CountryCode.Substring(4);
            }
            return viewModel;
        }

        /// <summary>
        /// Create a new international address object from the view model.
        /// </summary>
        /// <param name="viewModel">The model to get the data from.</param>
        /// <returns>The created international address object.</returns>
        public static InternationalAddress ToInternationalAddress(this InternationalAddressViewModel viewModel)
        {
            if (!viewModel.HasAnyValue())
            {
                return null;
            }

            return new InternationalAddress
            {
                Country = EnumExtensions.TryParse<CountryType>("Item" + viewModel.CountryCode),
                InternationalAddressLine = viewModel.InternationalAddressLine,
                InternationalPostcode = viewModel.InternationalPostcode,
                InternationalStateProvince = viewModel.InternationalStateProvince
            };
        }
    }
}