﻿#region Using Statements

using System.Web.Mvc;
using System.Web.Routing;

using HIPS.Web.ModelInterface.Common;

#endregion Using Statements

namespace HIPS.Web.UI.Filters
{
    /// <summary>
    /// Provides an action filter that enforces selection of a healthcare provider organisation.
    /// </summary>
    public class HpoRequiredFilter : IActionFilter
    {
        #region Fields

        /// <summary>
        /// Gets or sets the session configuration used by this class.
        /// </summary>
        private readonly ISessionConfiguration sessionConfiguration;

        #endregion Fields

        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="HpoRequiredFilter"/> class.
        /// </summary>
        /// <param name="sessionConfiguration">Session configuration to be used by this class.</param>
        public HpoRequiredFilter(ISessionConfiguration sessionConfiguration)
        {
            this.sessionConfiguration = sessionConfiguration;
        }

        #endregion Constructors

        #region Methods

        #region Overrides

        /// <summary>
        /// Overrides the OnActionExecuting method to implement the action filter logic.
        /// </summary>
        /// <param name="filterContext">Context for the action filter.</param>
        public void OnActionExecuting(ActionExecutingContext filterContext)
        {
            if (this.sessionConfiguration.RepresentingHospital == null)
            {
                // Retrieve required data from context.
                string requestedResource = string.Empty;

                if ((filterContext.HttpContext != null) && (filterContext.HttpContext.Request != null))
                {
                    requestedResource = filterContext.HttpContext.Request.Url.AbsolutePath;
                }

                filterContext.Controller.TempData["HpoRequiredMessage"] = "The resource you requested requires selection of a healthcare provider organisation. After making a selection you will be redirected to the originally requested resource.";

                if (!requestedResource.StartsWith("/Embedded"))
                {
                    // Redirect to "Select Healthcare Provider Organisation" action.
                    filterContext.Result = new RedirectToRouteResult(
                        new RouteValueDictionary()
                        {
                            { "action", "SelectHpo" },
                            { "controller", "Common" },
                            { "area", string.Empty },
                            { "returnUrl", requestedResource }
                        });
                }
            }

            // Otherwise, proceed to originally requested function.
        }

        /// <summary>
        /// Overrides the OnActionExecuted method to implement the action filter logic.
        /// </summary>
        /// <param name="filterContext">Context for the action filter.</param>
        public void OnActionExecuted(ActionExecutedContext filterContext)
        {
            // Do nothing.
        }

        #endregion Overrides

        #endregion Methods
    }
}