﻿namespace HIPS.Web.UI.Helpers.Mapping.Context
{
    /// <summary>
    /// Provides context used when mapping hospitals.
    /// </summary>
    public class HospitalMappingContext
    {
        #region Properties

        /// <summary>
        /// Gets or sets the hospital code system to be used during mapping.
        /// </summary>
        public string HospitalCodeSystem { get; set; }

        #endregion Properties

        #region Constructors

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="hospitalCodeSystem">Hospital code system to be used during mapping.</param>
        public HospitalMappingContext(string hospitalCodeSystem)
        {
            this.HospitalCodeSystem = hospitalCodeSystem;
        }

        #endregion Constructors
    }
}