﻿using AutoMapper;
using HIPS.Web.Components.Common;
using HIPS.Web.Model.Subscription;
using HIPS.Web.UI.Areas.Subscription.ViewModels;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{
    public class SubscriptionProfile : Profile
    {
        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>        
        protected override void Configure()
        {
            // ViewModel --> Data
            this.CreateMap<AreaOfInterestViewModel, AreaOfInterest>()
                .ForMember(dest => dest.Areas, opt => opt.MapFrom(src => src.Areas))
                .ForMember(dest => dest.Occupations, opt => opt.MapFrom(src => src.Occupations))
                .ForMember(dest => dest.Classifications, opt => opt.MapFrom(src => src.Classifications));

            this.CreateMap<GeographicalAreaViewModel, GeographicalArea>()
                .ForMember(dest => dest.Postcode, opt => opt.MapFrom(src => src.Postcode == "*" ? null : src.Postcode))
                .ForMember(dest => dest.Suburb, opt => opt.MapFrom(src => src.Suburb == "*" ? null : src.Suburb));

            this.CreateMap<IndividualOccupationViewModel, IndividualOccupation>();

            this.CreateMap<OrganisationClassificationViewModel, LocationClassification>();

            this.CreateMap<ExtraIndividualViewModel, ProviderIdentifierSearch>();

            this.CreateMap<ExtraOrganisationViewModel, ProviderIdentifierSearch>();

            // Data --> ViewModel
            this.CreateMap<AreaOfInterest, AreaOfInterestViewModel>();

            this.CreateMap<GeographicalArea, GeographicalAreaViewModel>();

            this.CreateMap<IndividualOccupation, IndividualOccupationViewModel>();

            this.CreateMap<LocationClassification, OrganisationClassificationViewModel>();

            this.CreateMap<ReferenceItem, GeographicalAreaViewModel>()
                .ForMember(dest => dest.Suburb, opt => opt.MapFrom(src => src.DisplayName))
                .ForMember(dest => dest.State, opt => opt.ResolveUsing<StateResolver>())
                .ForMember(dest => dest.Postcode, opt => opt.MapFrom(src => src.SubCode));

            this.CreateMap<ReferenceItem, IndividualOccupationViewModel>()
                .ForMember(dest => dest.Code, opt => opt.MapFrom(src => src.Code))
                .ForMember(dest => dest.Set, opt => opt.MapFrom(src => "Type"))
                .ForMember(dest => dest.Description, opt => opt.MapFrom(src => src.DisplayName));

            this.CreateMap<ReferenceItem, SelectListItem>()
                .ForMember(dest => dest.Text, opt => opt.MapFrom(src => src.DisplayName))
                .ForMember(dest => dest.Value, opt => opt.MapFrom(src => src.Code));
        }


        internal class StateResolver : ValueResolver<ReferenceItem, string>
        {
            protected override string ResolveCore(ReferenceItem source)
            {
                string strResult = string.Empty;

                int intPostCode = int.Parse(source.SubCode);
                if (intPostCode >= 200 && intPostCode <= 299)
                {
                    strResult = "ACT";
                }

                if (intPostCode >= 800 && intPostCode <= 999)
                {
                    strResult = "NT";
                }

                if (intPostCode >= 1000 && intPostCode <= 2599)
                {
                    strResult = "NSW";
                }

                if (intPostCode >= 2600 && intPostCode <= 2618)
                {
                    strResult = "ACT";
                }

                if (intPostCode >= 2619 && intPostCode <= 2899)
                {
                    strResult = "NSW";
                }

                if (intPostCode >= 2900 && intPostCode <= 2920)
                {
                    strResult = "ACT";
                }

                if (intPostCode >= 2921 && intPostCode <= 2999)
                {
                    strResult = "NSW";
                }

                if (intPostCode >= 3000 && intPostCode <= 3999)
                {
                    strResult = "VIC";
                }

                if (intPostCode >= 4000 && intPostCode <= 4999)
                {
                    strResult = "QLD";
                }

                if (intPostCode >= 5000 && intPostCode <= 5999)
                {
                    strResult = "SA";
                }

                if (intPostCode >= 6000 && intPostCode <= 6999)
                {
                    strResult = "WA";
                }

                if (intPostCode >= 7000 && intPostCode <= 7999)
                {
                    strResult = "TAS";
                }

                if (intPostCode >= 8000 && intPostCode <= 8999)
                {
                    strResult = "VIC";
                }

                if (intPostCode >= 9000 && intPostCode <= 9999)
                {
                    strResult = "QLD";
                }

                return strResult;
            }
        }

        #endregion
    }
}
