﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.DataIntegrity
{
    /// <summary>
    /// View model for selecting a hospital and displaying its current patients.
    /// </summary>
    public class PatientsViewModel : DataIntegrityViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="PatientsViewModel" /> class.
        /// </summary>
        public PatientsViewModel()
        {
            this.Hospitals = Enumerable.Empty<SelectListItem>();
            this.Patients = new List<PatientViewModel>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets the list of hospitals available for selection.
        /// </summary>
        public IEnumerable<SelectListItem> Hospitals { get; internal set; }

        /// <summary>
        /// Gets the list of patients for a selected hospital.
        /// </summary>
        public List<PatientViewModel> Patients { get; internal set; }

        /// <summary>
        /// Gets a value indicating whether to style the page for printing.
        /// </summary>
        public bool UsePrintStyles { get; internal set; }

        #endregion Properties
    }
}