﻿using System;
using System.Web;
using System.Web.Mvc;

namespace HIPS.Web.Components.Web
{
    /// <summary>
    /// Disables client-side caching.
    /// </summary>
    /// <remarks>
    /// Source: http://stackoverflow.com/a/10011896/364
    /// </remarks>
    public class NoCacheAttribute : ActionFilterAttribute
    {
        public override void OnResultExecuting(ResultExecutingContext filterContext)
        {
            filterContext.HttpContext.Response.Cache.SetExpires(DateTime.UtcNow.AddDays(-1));
            filterContext.HttpContext.Response.Cache.SetValidUntilExpires(false);
            filterContext.HttpContext.Response.Cache.SetRevalidation(HttpCacheRevalidation.AllCaches);
            filterContext.HttpContext.Response.Cache.SetCacheability(HttpCacheability.NoCache);
            filterContext.HttpContext.Response.Cache.SetNoStore();
            filterContext.HttpContext.Response.Cache.SetProxyMaxAge(TimeSpan.Zero);
            base.OnResultExecuting(filterContext);
        }
    }
}