﻿using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using AutoMapper;
using HIPS.ServiceContracts.Common.Fault;
using HIPS.Web.Components.ServiceModel;

namespace HIPS.Web.Data.Hips.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile faults.
    /// </summary>
    internal class FaultProfile : Profile
    {
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        protected override void Configure()
        {
            /*
            Service --> Common
            */

            // ServiceOperationFault

            this.CreateMap<FaultException<ServiceOperationFault>, List<ResponseMessage>>()
                .ConstructUsing(
                    (System.Func<FaultException<ServiceOperationFault>, List<ResponseMessage>>)
                    (src => new List<ResponseMessage>() { ObjectMapper.Map<ResponseMessage>(src.Detail) }));

            this.CreateMap<ServiceOperationFault, ResponseMessage>()
                .ForMember(dest => dest.Level, opt => opt.UseValue(HIPS.Web.Components.Common.MessageLevel.Error))
                .ForMember(dest => dest.Description, opt => opt.MapFrom(src => this.GetFaultDescription(src.Message, src.FaultIdentifier)));

            // InvalidRequestFault
            this.CreateMap<FaultException<InvalidRequestFault>, List<ResponseMessage>>()
                .ConstructUsing(
                    (System.Func<FaultException<InvalidRequestFault>, List<ResponseMessage>>)
                    (src => new List<ResponseMessage>().Concat(new List<ResponseMessage>() { ObjectMapper.Map<ResponseMessage>(src.Detail) }).Concat(ObjectMapper.Map<List<ResponseMessage>>(src.Detail.Messages)).ToList()));

            this.CreateMap<InvalidRequestFault, ResponseMessage>()
                .ForMember(dest => dest.Level, opt => opt.UseValue(HIPS.Web.Components.Common.MessageLevel.Error))
                .ForMember(dest => dest.Description, opt => opt.MapFrom(src => this.GetFaultDescription(src.Message, src.FaultIdentifier)));

            // ItemNotFoundFault

            this.CreateMap<FaultException<ItemNotFoundFault>, List<ResponseMessage>>()
                .ConstructUsing((FaultException<ItemNotFoundFault> src) => new List<ResponseMessage> { ObjectMapper.Map<ResponseMessage>(src.Detail) });

            this.CreateMap<ItemNotFoundFault, ResponseMessage>()
                .ForMember(dest => dest.Level, opt => opt.UseValue(HIPS.Web.Components.Common.MessageLevel.Error))
                .ForMember(dest => dest.Description, opt => opt.MapFrom(src => this.GetFaultDescription(src.Message, src.FaultIdentifier)));

            // System.Exception
            this.CreateMap<System.Exception, List<ResponseMessage>>()
                .ConstructUsing(
                    (System.Func<System.Exception, List<ResponseMessage>>)
                    (src => new List<ResponseMessage>() { ObjectMapper.Map<ResponseMessage>(src) }));

            this.CreateMap<System.Exception, ResponseMessage>()
                .ForMember(dest => dest.Level, opt => opt.UseValue(HIPS.Web.Components.Common.MessageLevel.Error))
                .ForMember(dest => dest.Description, opt => opt.MapFrom(src => src.Message));



        }

        private string GetFaultDescription(string message, string faultIdentifier)
        {
            return string.Format("{0} [Fault Identifier: {1}]", message, faultIdentifier);
        }
    }
}