﻿using AutoMapper;

using CommonSchema = HIPS.Web.Model.Messaging;
using ServiceSchema = HIPS.P2P.Service.Contract.Common.DTO;

namespace HIPS.Web.Data.P2P.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for messaging entities.
    /// </summary>
    public class MessagingProfile : Profile
    {
        #region Properties
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>        
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #endregion
        
        #region Methods
       
        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            /*
            Common --> Service
            */
            this.CreateMap<HIPS.Web.Model.OutboundMessageStatus, HIPS.P2P.Service.Contract.Common.OutboundMessageStatus>();

            this.CreateMap<CommonSchema.MessageAddressee, ServiceSchema.MessageAddressee>();
            this.CreateMap<CommonSchema.ProviderOrganisationIdentity, ServiceSchema.ProviderOrganisationIdentity>();
            this.CreateMap<CommonSchema.ProviderOrganisationIdentifier, ServiceSchema.ProviderOrganisationIdentifier>();
            this.CreateMap<CommonSchema.ProviderIdentifierType, ServiceSchema.ProviderIdentifierType>();

            this.CreateMap<CommonSchema.DateTimeRange, ServiceSchema.DateTimeRange>();

            /*
            Service --> Common
            */

            this.CreateMap<ServiceSchema.OutboundSealedMessage, CommonSchema.OutboundSealedMessage>();
            this.CreateMap<ServiceSchema.InboundSealedMessage, CommonSchema.InboundSealedMessage>();
            this.CreateMap<ServiceSchema.TransportResponse, CommonSchema.TransportResponse>();

            this.CreateMap<ServiceSchema.MessageAddressee, CommonSchema.MessageAddressee>();
            this.CreateMap<ServiceSchema.ConsumerIdentity, CommonSchema.ConsumerIdentity>();
            this.CreateMap<ServiceSchema.BinaryMessageContent, CommonSchema.BinaryMessageContent>();

            this.CreateMap<ServiceSchema.ProviderIndividualIdentity, CommonSchema.ProviderIndividualIdentity>();
            this.CreateMap<ServiceSchema.ProviderIndividualIdentifier, CommonSchema.ProviderIndividualIdentifier>();            
            this.CreateMap<ServiceSchema.IndividualName, CommonSchema.IndividualName>();
            this.CreateMap<ServiceSchema.IndividualNameAlias, CommonSchema.IndividualNameUsage>();

            this.CreateMap<ServiceSchema.ProviderOrganisationIdentity, CommonSchema.ProviderOrganisationIdentity>();
            this.CreateMap<ServiceSchema.ProviderOrganisationIdentifier, CommonSchema.ProviderOrganisationIdentifier>();
            this.CreateMap<ServiceSchema.ProviderIdentifierType, CommonSchema.ProviderIdentifierType>();
        }

        #endregion
    }
}
