﻿using AutoMapper;

using CommonSchema = HIPS.Web.Model;
using ServiceSchema = HIPS.P2P.Service.Contract.Common.DTO;

namespace HIPS.Web.Data.P2P.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for user identity.
    /// </summary>
    internal class UserIdentityProfile : Profile
    {
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            /*
            Common --> Service
            */

            // LocalUser
            this.CreateMap<CommonSchema.Identity.LocalUser, ServiceSchema.UserIdentity.LocalUser>();
        }

        #endregion
    }
}