﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Model.Subscription;

namespace HIPS.Web.Model.Directory.Search
{
    public class ProviderLocationSearch
    {
        #region Properties

        /// <summary>
        /// Gets or sets the location name.
        /// </summary> 
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the location description.
        /// </summary> 
        public string LocationDescription { get; set; }

        /// <summary>
        /// Gets or sets the identifier for this location, either a national or a local identifier.
        /// </summary> 
        public ProviderIdentifierSearch Identifier { get; set; }

        /// <summary>
        /// Gets or sets the address.
        /// </summary> 
        public AddressSearch Address { get; set; }

        /// <summary>
        /// Gets or sets the electronic contact detail.
        /// </summary> 
        public ElectronicContactSearch Contact { get; set; }

        /// <summary>
        /// Gets or sets the organisation type, service type and/or service unit.
        /// </summary> 
        public LocationClassification Classification { get; set; }

        #endregion
    }
}
