﻿namespace HIPS.Web.Model
{
    /// <summary>
    /// Status of the document process for upload and remove
    /// </summary>
    public enum LocalDocumentStatus
    {
        /// <summary>
        ///
        /// </summary>
        Unknown = 0,

        /// <summary>
        ///
        /// </summary>
        PendingUpload = 1,

        /// <summary>
        ///
        /// </summary>
        Uploaded = 2,

        /// <summary>
        ///
        /// </summary>
        FailedUpload = 3,

        /// <summary>
        ///
        /// </summary>
        PendingRemove = 4,

        /// <summary>
        ///
        /// </summary>
        Removed = 5,

        /// <summary>
        ///
        /// </summary>
        FailedRemove = 6
    }

    /// <summary>
    /// Represents the file type and semantics of an attachment.
    /// </summary>
    public enum AttachmentType
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents an additional JPEG image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a JPEG image.
        /// </summary>
        AttachedImageJpeg = 1,

        /// <summary>
        /// Represents an additional PNG image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a PNG image.
        /// </summary>
        AttachedImagePng = 2,

        /// <summary>
        /// Represents an additional TIFF image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a TIFF image.
        /// </summary>
        AttachedImageTiff = 3,

        /// <summary>
        /// Represents an additional GIF image attached to the document. This image will be shown
        /// in the CDA body under the main document. This file must be a GIF image.
        /// </summary>
        AttachedImageGif = 4,

        /// <summary>
        /// Represents an additional linked document. This will be linked from the body of the
        /// CDA document. This file must be a PDF document.
        /// </summary>
        AttachedDocumentPdf = 5,

        /// <summary>
        /// Represents the organisational logo that will appear in the header of the CDA document.
        /// This file must be a PNG image. If no attachment is supplied with this type, and there
        /// is a logo in the database Hospital table, then HIPS will include the logo from the
        /// database.
        /// </summary>
        OrganisationalLogoPng = 6,
    }

    /// <summary>
    /// Represents the status of the patient at the time of discharge and the
    /// place to which the person was or will be released. The valid codes
    /// are defined in AIHW 270094 titled "Episode of admitted patient care-
    /// separation mode, code N". Shorter, more user friendly display names
    /// were developed by NEHTA.
    /// </summary>
    public enum ModeOfSeparation
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents a discharge or transfer to an acute hospital.
        /// </summary>
        AcuteHospital = 1,

        /// <summary>
        /// Represents a discharge or transfer to a residential aged care service, unless this is the usual place of residence.
        /// </summary>
        AgedCareService = 2,

        /// <summary>
        /// Represents a discharge or transfer to a psychiatric hospital.
        /// </summary>
        PsychiatricCare = 3,

        /// <summary>
        /// Represents a discharge or transfer to other health care accommodation (includes mothercraft hospitals)
        /// </summary>
        OtherHealthService = 4,

        /// <summary>
        /// Represents a statistical discharge - type change.
        /// </summary>
        AdministrativeDischarge = 5,

        /// <summary>
        /// Represents that the patient left against medical advice or was discharged at own risk.
        /// </summary>
        SelfDischarge = 6,

        /// <summary>
        /// Represents a statistical discharge from leave.
        /// </summary>
        AdministrativeFromLeave = 7,

        /// <summary>
        /// Represents that the patient died.
        /// </summary>
        Deceased = 8,

        /// <summary>
        /// Represents that the patient was discharged to his/her usual residence, own accommodation or a welfare institution (includes prisons, hostels and group homes providing primarily welfare services).
        /// </summary>
        Home = 9,
    }

    /// <summary>
    /// Represents the status of this version of the document as communicated
    /// by the source system. The valid codes are defined by NCTIS titled
    /// "Admin Codes - Document Status".
    /// </summary>
    public enum SourceDocumentStatus
    {
        /// <summary>
        /// No value has been supplied. This represents an invalid invocation of the web service.
        /// </summary>
        None = 0,

        /// <summary>
        /// Represents an interim or draft version of the document. Interim versions are not normally
        /// uploaded to the PCEHR system.
        /// </summary>
        Interim = 1,

        /// <summary>
        /// Represents a final version of the document. This may be the first final version or an amendment.
        /// </summary>
        Final = 2,

        /// <summary>
        /// Represents a notification that the document has been withdrawn by the authoring organisation.
        /// Withdrawn versions are intended for delivery to point-to-point (P2P) recipients of the document
        /// and are not normally uploaded to the PCEHR system. Instead the document can be removed from the
        /// PCEHR system with a separate web service invocation.
        /// </summary>
        Withdrawn = 3,
    }

    /// <summary>
    /// Represents the status of a HPI-I
    /// </summary>
    public enum HpiiStatus
    {
        /// <summary>
        /// No further action.
        /// </summary>
        Active,

        /// <summary>
        /// A warning should be raised in HPI-I search if Retired HPii Status is returned.
        /// </summary>
        Retired,

        /// <summary>
        /// A warning should be raised in HPI-I search if Deactivated Hpii Status is returned.
        /// </summary>
        Deactivated,

        /// <summary>
        /// An alert or a warning is raised in HPI-I search if Resolved Hpii Status is returned.
        /// </summary>
        Resolved
    }
    
    /// <summary>
    /// Status of outbound message delivery.
    /// </summary>
    public enum OutboundMessageStatus
    {
        /// <summary>
        /// No message status has been defined.
        /// </summary>
        None = 0,

        /// <summary>
        /// The outbound message is awaiting delivery.
        /// </summary>
        Undelivered = 1,

        /// <summary>
        /// The outbound message has been delivered and is awaiting acknowledgement.
        /// </summary>
        Delivered = 2,

        /// <summary>
        /// An acknowledgement for the outbound message has been received.
        /// </summary>
        Responded = 3,

        /// <summary>
        /// The outbound message delivery has been acknowledged.
        /// </summary>
        Acknowledged = 4,

        /// <summary>
        /// The outbound message delivery processing has failed.
        /// </summary>
        Failed = 5,

        /// <summary>
        /// The attempt to deliver the outbound message has exceeded its expiry period.
        /// </summary>
        Expired = 6,

        /// <summary>
        /// The outbound message has been removed.
        /// </summary>
        Removed = 7,

        /// <summary>
        /// The outbound message has been retried.
        /// </summary>
        Retried = 8,

        /// <summary>
        /// The outbound message is Undelivered - Expired.
        /// </summary>
        UndeliveredExpired = 9,

        /// <summary>
        /// The outbound message is Undelivered - ExceedRetryCount.
        /// </summary>
        ExceedRetryCount = 10
    }

    /// <summary>
    /// Status of inbound message receipt.
    /// </summary>
    public enum InboundMessageStatus
    {
        /// <summary>
        /// No message status has been defined.
        /// </summary>
        None = 0,

        /// <summary>
        /// The inbound message has been received.
        /// </summary>
        Received = 1,

        /// <summary>
        /// The inbound message receipt is yet to be acknowledged.
        /// </summary>
        Unacknowledged = 2,

        /// <summary>
        /// The inbound message has been acknowledged, but the message is yet to be published.
        /// </summary>
        Unpublished = 3,

        /// <summary>
        /// The inbound message has been published to subscribers.
        /// </summary>
        Published = 4,

        /// <summary>
        /// The inbound message has been retrieved.
        /// </summary>
        Retrieved = 5,

        /// <summary>
        /// The inbound message receipt processing has failed.
        /// </summary>
        Failed = 6,

        /// <summary>
        /// The inbound message has expired.
        /// </summary>
        Expired = 7,

        /// <summary>
        /// The inbound message has been removed.
        /// </summary>
        Removed = 8
    }

    /// <summary>
    /// Class for a transport response.
    /// </summary>
    public enum TransportResponseClass
    {
        /// <summary>
        /// No transport response class has been defined.
        /// </summary>
        None = 0,

        /// <summary>
        /// The transport response class is success.
        /// </summary>
        Success = 1,

        /// <summary>
        /// The transport response class is information.
        /// </summary>
        Information = 2,

        /// <summary>
        /// The transport response class is warning.
        /// </summary>
        Warning = 3,

        /// <summary>
        /// The transport response class is error.
        /// </summary>
        Error = 4
    }

    /// <summary>
    /// Status for a transport response.
    /// </summary>
    public enum TransportResponseStatus
    {
        /// <summary>
        /// No response status has been defined.
        /// </summary>
        None = 0,

        /// <summary>
        /// The transport response for the inbound message is yet to be delivered.
        /// </summary>
        Undelivered = 1,

        /// <summary>
        /// The transport response for the inbound message has been delivered.
        /// </summary>
        Delivered = 2,

        /// <summary>
        /// Delivery of the transport response for the inbound message has expired.
        /// </summary>
        Expired = 3,

        /// <summary>
        /// Operator has aborted the delivery of the transport response.
        /// </summary>
        Aborted = 4,

        /// <summary>
        /// A transport response has been received for the outbound message.
        /// </summary>
        Received = 20
    }

    /// <summary>
    /// Enumeration of entity types, used to specify which entities should be returned in the search results.
    /// </summary>
    public enum Entity
    {
        /// <summary>
        /// No entities required.
        /// </summary>
        None = 0,

        /// <summary>
        /// Return the links between individuals and organisation service locations.
        /// </summary>
        Link = 1,

        /// <summary>
        /// Return the individual practitioners.
        /// </summary>
        Individual = 2,

        /// <summary>
        /// Return the names of each individual practitioner.
        /// </summary>
        IndividualName = 3,

        /// <summary>
        /// Return the classifications of each individual practitioner.
        /// </summary>
        IndividualClassification = 4,

        /// <summary>
        /// Return the contact details of each individual practitioner.
        /// </summary>
        IndividualContact = 5,

        /// <summary>
        /// Return the healthcare provider organisations.
        /// </summary>
        Organisation = 6,

        /// <summary>
        /// Return the additional names of each healthcare provider organisation.
        /// </summary>
        OrganisationName = 7,

        /// <summary>
        /// Return the organisation service locations.
        /// </summary>
        Location = 8,

        /// <summary>
        /// Return the classifications of each organisation service location.
        /// </summary>
        LocationClassification = 9,

        /// <summary>
        /// Return the address of each organisation service location.
        /// </summary>
        LocationAddress = 10,

        /// <summary>
        /// Return the contact details of each organisation service location.
        /// </summary>
        LocationContact = 11,

        /// <summary>
        /// Return the document channel preferences of each organisation service location.
        /// </summary>
        DocumentChannelPreference = 12,

        /// <summary>
        /// Return the interaction records of each organisation.
        /// </summary>
        InteractionRecord = 13,
    }
}