﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Messaging
{
    /// <summary>
    /// Represents the identity of a consumer who may be the subject of care (patient) in an electronic health message.
    /// </summary>
    public class ConsumerIdentity
    {
        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        public DateTime DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the family name.
        /// </summary>
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names.
        /// </summary>
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the IHI.
        /// </summary>
        public string Ihi { get; set; }

        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        public string Sex { get; set; }
    }
}
