﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class AreaOfInterest
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="AreaOfInterest"/> class.
        /// </summary>
        public AreaOfInterest()
        {
            this.Areas = new List<GeographicalArea>();
            this.Occupations = new List<IndividualOccupation>();
            this.Classifications = new List<LocationClassification>();
            this.ExtraMembers = new List<ProviderIdentifierSearch>();
        }

        #region Properties

        /// <summary>
        /// Gets or sets the URI allocated by NEPS to identify this area of interest definition.
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the description of the area of interest.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets the list of geographical areas.
        /// </summary>
        public List<GeographicalArea> Areas { get; set; }

        /// <summary>
        /// Gets or sets the list of individual occupations.
        /// </summary>
        public List<IndividualOccupation> Occupations { get; set; }

        /// <summary>
        /// Gets or sets the list of location classifications.
        /// </summary>
        public List<LocationClassification> Classifications { get; set; }

        /// <summary>
        /// Gets or sets the list of identifiers of extra members. The identifiers
        /// must be NHSD URI for individuals (NHSDI) or NHSD URI for organisations (NHSDO).
        /// </summary>
        public List<ProviderIdentifierSearch> ExtraMembers { get; set; }

        #endregion Properties
    }
}
