﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class ChannelCarrier
    {
        #region Properties

        /// <summary>
        /// Gets or sets the NHSD URI for the channel carrier.
        /// </summary>        
        public string ChannelCarrierURI { get; set; }

        /// <summary>
        /// Gets or sets the Code for the channel carrier.
        /// </summary>        
        public string ChannelCarrierCode { get; set; }

        /// <summary>
        /// Gets or sets the Display Name for the channel carrier.
        /// </summary>        
        public string ChannelCarrierDisplayName { get; set; }

        /// <summary>
        /// Gets or sets the The relative preference of this carrier among 
        /// those supported for delivery of a particular payload scheme 
        /// via a particular channel type to a particular organisation or location..
        /// </summary>        
        public long Preference { get; set; }

        #endregion
    }
}
