﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class ElectronicContact
    {
        #region Properties

        /// <summary>
        /// Gets or sets the NHSD URI for the Contact Type.
        /// </summary>
        public string ContactTypeUri { get; set; }

        /// <summary>
        /// Gets or sets the code for the contact type.
        /// </summary>
        public string ContactTypeCode { get; set; }

        /// <summary>
        /// Gets or sets the DisplayName for the contact type.
        /// </summary>
        public string ContactTypeDisplayName { get; set; }

        /// <summary>
        /// Gets or sets the Uri for the contact purpose.
        /// </summary>
        public string ContactPurposeUri { get; set; }

        /// <summary>
        /// Gets or sets the Code for the contact purpose.
        /// </summary>
        public string ContactPurposeCode { get; set; }

        /// <summary>
        /// Gets or sets the DisplayName for the contact purpose.
        /// </summary>
        public string ContactPurposeDisplayName { get; set; }

        /// <summary>
        /// Gets or sets the Actual number or address that can be used to contact the individual or organisation.
        /// </summary>
        public string Value { get; set; }

        /// <summary>
        /// Indicates whether this is the preferred method of contacting the individual or organisation.
        /// </summary>
        public long Preference { get; set; }

        #endregion
    }
}
