﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class FindOrganisationsRequest
    {
        #region Properties

        /// <summary>
        /// Gets or sets the last name pattern, which can contain an asterisk
        /// for wildcard search.
        /// </summary>
        public string NamePattern { get; set; }

        /// <summary>
        /// Gets or sets the individual identifier.
        /// </summary>
        public ProviderIdentifierSearch Identifier { get; set; }

        /// <summary>
        /// Gets or sets the organisation search criteria.
        /// </summary>
        public LocationClassification Classification { get; set; }

        /// <summary>
        /// Gets or sets the location address.
        /// </summary>
        public AddressSearch Address { get; set; }

        /// <summary>
        /// Gets or sets the proximity radius.
        /// </summary>
        public int? ProximityRadius { get; set; }

        #endregion
    }
}
