﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Model.AssistedRegistration;
using HIPS.Web.Model.Messaging;

namespace HIPS.Web.Model.Subscription
{
    public class ProviderIndividual
    {
        #region Properties

        /// <summary>
        /// Gets or sets the primary identifier of the individual.
        /// </summary>
        public string IndividualId { get; set; }

        /// <summary>
        /// Gets or sets the provider identifiers, including national and local identifiers.
        /// </summary>        
        public List<ProviderIndividualIdentifier> Identifiers { get; set; }

        /// <summary>
        /// Gets or sets the list of names for the individual.
        /// </summary>        
        public IndividualName Name { get; set; }

        /// <summary>
        /// Gets or sets the list of aliases for the individual.
        /// </summary>        
        public List<IndividualNameUsage> Aliases { get; set; }

        /// <summary>
        /// Gets or sets the list of provider types, specialties and specialisations.
        /// </summary>        
        public List<IndividualOccupation> Occupations { get; set; }

        /// <summary>
        /// Gets or sets the list of electronic contact details.
        /// </summary>        
        public List<ElectronicContact> Contacts { get; set; }

        /// <summary>
        /// Gets or sets the sex of the individual.
        /// </summary>        
        public Sex Sex { get; set; }

        /// <summary>
        /// Gets or sets the date of birth of the individual.
        /// </summary>        
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the individual is subscribed.
        /// </summary>
        public bool IsInSubscription { get; set; }

        #endregion
    }
}
