﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.Model.Subscription
{
    public class ProviderLink
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="ProviderLink"/> class.
        /// </summary>
        public ProviderLink()
        {
            this.LinkIdentifiers = new List<ProviderLinkIdentifier>();
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets or sets the list of identifiers of this link.
        /// </summary>
        public List<ProviderLinkIdentifier> LinkIdentifiers { get; set; }

        /// <summary>
        /// Gets or sets the primary identifier of the location.
        /// </summary>
        public string LocationId { get; set; }

        /// <summary>
        /// Gets or sets the primary identifier of the individual.
        /// </summary>
        public string IndividualId { get; set; }

        #endregion
    }
}
