using System;
using System.Collections.Generic;
using HIPS.CommonSchemas;
using HIPS.Web.Model.AssistedRegistration;
using HIPS.Web.Model.Common;

namespace HIPS.Web.ModelInterface.AssistedRegistration
{
    public interface IAssistedRegistrationService : IDisposable
    {
        RegisterResponse RegisterApplicant(PersonDemographic applicant, Hospital applicantHospital, bool applicantConsent, IndigenousStatus applicantIndigenousStatus, Dictionary<MedicareConsent, bool> medicareConsents, IdentityVerificationMethod identityVerificationMethod, IvcDeliveryMethodDecision ivcDeliveryMethod, UserDetails operatingUser, int? applicantPatientMasterId);

        RegisterResponse RegisterApplicant(ValidatedPatient applicant, bool applicantConsent, IndigenousStatus applicantIndigenousStatus, Dictionary<MedicareConsent, bool> medicareConsents, IdentityVerificationMethod identityVerificationMethod, IvcDeliveryMethodDecision ivcDeliveryMethod, UserDetails operatingUser, int? applicantPatientMasterId);

        RegisterResponse RegisterDependant(PersonDemographic applicant, Hospital applicantHospital, bool applicantConsent, IndigenousStatus applicantIndigenousStatus, PersonDemographic representative, bool representativeConsent, Dictionary<MedicareConsent, bool> medicareConsents, IdentityVerificationMethod identityVerificationMethod, IvcDeliveryMethodDecision ivcDeliveryMethod, UserDetails operatingUser, int? applicantPatientMasterId);

        RegisterResponse RegisterDependant(ValidatedPatient applicant, bool applicantConsent, IndigenousStatus applicantIndigenousStatus, PersonDemographic representative, bool representativeConsent, Dictionary<MedicareConsent, bool> medicareConsents, IdentityVerificationMethod identityVerificationMethod, IvcDeliveryMethodDecision ivcDeliveryMethod, UserDetails operatingUser, int? applicantPatientMasterId);
    }
}