﻿using System;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PatientSchemas;
using HIPS.Web.Components.ServiceModel;

namespace HIPS.Web.ModelInterface.ConsentManagement
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of an episode repository.
    /// </summary>
    public interface IEpisodeRepository : IDisposable
    {
        /// <summary>
        /// Retrieves a list of recent episodes for a patient at a hospital.
        /// </summary>
        /// <param name="patientIdentifier">The MRN that identifies the patient at the hospital.</param>
        /// <param name="user">User requesting the operation.</param>
        /// <returns>ServiceResponse containing a PatientEpisodeListResponse containing the results of the operation.</returns>
        ServiceResponse<PatientEpisodeListResponse> ListPatientEpisodesInHospital(Mrn patientIdentifier, UserDetails user);

        /// <summary>
        /// Retrieves details of a single episode.
        /// </summary>
        /// <param name="user">User requesting the operation.</param>
        /// <param name="episodeId">The visit number that identifies the episode among all episodes for the patient.</param>
        /// <param name="patientIdentifier">The MRN that identifies the patient at the hospital.</param>
        /// <returns>ServiceResponse containing a EpisodePatientDetailsResponse containing the results of the operation.</returns>
        ServiceResponse<EpisodePatientDetailsResponse> GetEpisodeDetails(UserDetails user, string episodeId, Mrn patientIdentifier);
    }
}