﻿using System;
using System.Collections.Generic;
using HIPS.CommonSchemas.Hi;
using HIPS.Web.Components.Cache;

namespace HIPS.Web.ModelInterface.Hi
{
    public class CachedHiReferenceRepository : IHiReferenceRepository
    {
        private IHiReferenceRepository ReferenceRepository { get; set; }

        private ICacheProvider CacheProvider { get; set; }

        private readonly string CacheKeyFormat;

        public CachedHiReferenceRepository(IHiReferenceRepository referenceRepository, ICacheProvider cacheProvider, string cacheKeyPrefix = "")
        {
            ReferenceRepository = referenceRepository;
            CacheProvider = cacheProvider;
            CacheKeyFormat = cacheKeyPrefix + ".CachedHiReferenceRepository.{0}";
        }

        public List<HiSex> GetHiSexes()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetHiSexes()"),
                                     () => ReferenceRepository.GetHiSexes());
        }

        public List<HiPostalDeliveryType> GetHiPostalDeliveryTypes()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetHiPostalDeliveryTypes()"),
                                     () => ReferenceRepository.GetHiPostalDeliveryTypes());
        }

        public List<HiUnitType> GetHiUnitTypes()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetHiUnitTypes()"),
                                     () => ReferenceRepository.GetHiUnitTypes());
        }

        public List<HiLevelType> GetHiLevelTypes()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetHiLevelTypes()"),
                                     () => ReferenceRepository.GetHiLevelTypes());
        }

        public List<HiStreetType> GetHiStreetTypes()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetHiStreetTypes()"),
                                     () => ReferenceRepository.GetHiStreetTypes());
        }

        public List<HiStreetSuffixType> GetHiStreetSuffixTypes()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetHiStreetSuffixTypes()"),
                                     () => ReferenceRepository.GetHiStreetSuffixTypes());
        }

        public List<HiState> GetHiStates()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetHiStates()"),
                                     () => ReferenceRepository.GetHiStates());
        }

        public List<HiCountry> GetHiCountries()
        {
            return CacheProvider.GetOrSet(String.Format(CacheKeyFormat, "GetHiCountries()"),
                                     () => ReferenceRepository.GetHiCountries());
        }

        /// <summary>
        /// Performs application-defined tasks associated with freeing, releasing, or resetting unmanaged resources.
        /// </summary>
        public void Dispose()
        {
            if (ReferenceRepository != null)
            {
                ReferenceRepository.Dispose();
                ReferenceRepository = null;
            }
        }
    }
}