﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Components.Cache;
using HIPS.Web.Model.Hpii;

namespace HIPS.Web.ModelInterface.HpiiSearch
{
    /// <summary>
    /// Implements a repository for interacting with hpii search references.
    /// </summary>
    public class CachedHpiiSearchReferenceRepository : IHpiiSearchReferenceRepository
    {
        #region Fields

        /// <summary>
        /// Cache key format.
        /// </summary>
        private readonly string cacheKeyFormat;

        /// <summary>
        /// Cache provider.
        /// </summary>
        private readonly ICacheProvider cacheProvider;

        /// <summary>
        /// Reference repository.
        /// </summary>
        private IHpiiSearchReferenceRepository referenceRepository;

        #endregion Fields
        
        #region Constructors
        
        /// <summary>
        /// Initialises a new instance of the <see cref="CachedHpiiSearchReferenceRepository"/> class.
        /// </summary>
        /// <param name="referenceRepository">Reference repository.</param>
        /// <param name="cacheProvider">Cache provider.</param>
        /// <param name="cacheKeyPrefix">Cache key format.</param>
        public CachedHpiiSearchReferenceRepository(
            IHpiiSearchReferenceRepository referenceRepository,
            ICacheProvider cacheProvider,
            string cacheKeyPrefix = "")
        {
            this.referenceRepository = referenceRepository;
            this.cacheProvider = cacheProvider;
            this.cacheKeyFormat = cacheKeyPrefix + ".CachedDischargeSummaryReferenceRepository.{0}";
        }
        
        #endregion Constructors
        
        #region Methods

        /// <summary>
        /// Gets all Titles.
        /// </summary>
        /// <returns>List of Titles.</returns>
        public List<Title> GetTitles()
        {
            return this.cacheProvider.GetOrSet(string.Format(this.cacheKeyFormat, "GetTitles()"), () => this.referenceRepository.GetTitles());
        }

        /// <summary>
        /// Gets all Suffixes.
        /// </summary>
        /// <returns>List of Suffixes.</returns>
        public List<Suffix> GetSuffixes()
        {
            return this.cacheProvider.GetOrSet(string.Format(this.cacheKeyFormat, "GetSuffixes()"), () => this.referenceRepository.GetSuffixes());
        }

        /// <summary>
        /// Dispose.
        /// </summary>
        public void Dispose()
        {
            if (this.referenceRepository != null)
            {
                this.referenceRepository.Dispose();
                this.referenceRepository = null;
            }
        }

        #endregion
    }
}
