﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Model.Hpii;

namespace HIPS.Web.ModelInterface.HpiiSearch
{
    /// <summary>
    /// Defines the operations to be supported by an implementation of a cached hpii search reference repository.
    /// </summary>
    public interface IHpiiSearchReferenceRepository : IDisposable
    {
        /// <summary>
        /// Gets all Titles.
        /// </summary>
        /// <returns>List of Titles.</returns>
        List<Title> GetTitles();

        /// <summary>
        /// Gets all Suffixes.
        /// </summary>
        /// <returns>List of Suffixes.</returns>
        List<Suffix> GetSuffixes();
    }
}
