using System.Web.Mvc;
using System.Web.Routing;
using HIPS.Web.Components.Web;
using HIPS.Web.UI.Helpers;

namespace HIPS.Web.UI
{
    /// <summary>
    /// MVC route configuration.
    /// </summary>
    public class RouteConfig
    {
        /// <summary>
        /// Register MVC routes.
        /// </summary>
        /// <param name="routes">Collection to add routes to.</param>
        public static void RegisterRoutes(RouteCollection routes)
        {
            routes.IgnoreWindowsLoginRoute();

            routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

            // PCEHR View specific routes:

            System.Func<object, string> titleMethod;

            // PD View:

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Prescription and Dispense View for {0}", vm.CurrentPatient.Name) : string.Empty;
            };

            /* PD View Rendered */
            routes.MapRoute(
                name: string.Empty,
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView/Content/View",
                defaults: new
                {
                    controller = "PcehrView",
                    action = "PrescriptionDispenseViewContentView"
                }).SetTitle(titleMethod);

            /* PD View IFrame */
            routes.MapRoute(
                name: string.Empty,
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView/Content",
                defaults: new { controller = "PcehrView", action = "PrescriptionDispenseViewContent" }
                ).SetTitle(titleMethod);

            /* PD View wrapper with filters */
            routes.MapRoute(
                name: string.Empty,
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView",
                defaults: new { controller = "PcehrView", action = "PrescriptionDispenseView" }
                ).SetTitle(titleMethod);

            // Document:

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return string.Format("{0} for {1}", vm.CurrentDocument.CategoryName, vm.CurrentPatient.Name);
            };

            /* Document Rendered */
            routes.MapRoute(
                name: string.Empty,
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}/Content/View/{filename}",
                defaults: new { controller = "PcehrView", action = "DocumentContentView" }
                ).SetTitle(titleMethod);

            /* Document IFrame Wrapper */
            routes.MapRoute(
                name: string.Empty,
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}/Content",
                defaults: new { controller = "PcehrView", action = "DocumentContent" }
                ).SetTitle(titleMethod);

            /* Document Wrapper, Header etc. */
            routes.MapRoute(
                name: "PcehrView-Document",
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}",
                defaults: new { controller = "PcehrView", action = "Document" }
                ).SetTitle(titleMethod);

            // Gain Access:

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Gain Access for {0}", vm.CurrentPatient.Name) : "Gain Access";
            };

            routes.MapRoute(
                name: string.Empty,
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/GainAccess",
                defaults: new { controller = "PcehrView", action = "GainAccess" }
                ).SetTitle(titleMethod);

            // Patient:

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Patient Summary for {0}", vm.CurrentPatient.Name) : "Patient Summary";
            };

            routes.MapRoute(
                name: string.Empty,
                url: "PcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PatientSummary",
                defaults: new { controller = "PcehrView", action = "PatientSummary" }
                ).SetTitle(titleMethod);

            // Hospitals / Patients:

            titleMethod = (m) =>
                {
                    var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                    return vm.IsHospitalSelected() ? string.Format("Patients at {0}", vm.CurrentHospital.Name) : "Hospitals";
                };

            routes.MapRoute(
                name: string.Empty,
                url: "PcehrView/Patients",
                defaults: new { controller = "PcehrView", action = "Patients" }
                ).SetTitle(titleMethod);

            // DataIntegrity / PatientsWithoutIHI :

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.DataIntegrity.DataIntegrityViewModelBase;
                return vm.IsHospitalSelected() ? string.Format(" Patients without IHI at {0}", vm.CurrentHospital.Name) : "Patients Without IHI";
            };

            routes.MapRoute(
                name: string.Empty,
                url: "DataIntegrity/PatientsWithoutIHI/Report",
                defaults: new { controller = "DataIntegrity", action = "PatientsWithoutIhiReport" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "DataIntegrity/PatientsWithoutIHI",
                defaults: new { controller = "DataIntegrity", action = "PatientsWithoutIhi" }
                ).SetTitle(titleMethod);

            // DisclosureManagement :
            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.DisclosureManagement.DisclosureManagementViewModelBase;
                return vm.IsHospitalSelected() ? string.Format(" Disclose Hidden Digital Health Record at {0}", vm.CurrentHospital.Name) : "Disclose Hidden Digital Health Record";
            };

            routes.MapRoute(
                name: string.Empty,
                url: "DisclosureManagement/Patients",
                defaults: new { controller = "DisclosureManagement", action = "Patients" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "DisclosureManagement/Hospitals/{hospitalId}/Patients/Lookup",
               defaults: new { controller = "DisclosureManagement", action = "LookupMrn" }
               ).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "DisclosureManagement/Hospitals/{hospitalId}/Patients/{patientId}/DisclosePcehr",
               defaults: new { controller = "DisclosureManagement", action = "DisclosePcehr" }
               ).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "DisclosureManagement/Hospitals/{hospitalId}/Patients/{patientId}/RemoveDisclosure",
               defaults: new { controller = "DisclosureManagement", action = "RemoveDisclosure" }
               ).SetTitle(titleMethod);

            // ConsentManagement / WithdrawConsent :

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.ConsentManagement.ConsentManagementViewModelBase;
                return vm.IsHospitalSelected() ? string.Format("Withdraw Consent at {0}", vm.CurrentHospital.Name) : "Withdraw Consent";
            };

            routes.MapRoute(
                name: string.Empty,
                url: "ConsentManagement/Patients",
                defaults: new { controller = "ConsentManagement", action = "Patients" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "ConsentManagement/Hospitals/{hospitalId}/Patients/Lookup",
               defaults: new { controller = "ConsentManagement", action = "LookupMrn" }
               ).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "ConsentManagement/Hospitals/{hospitalId}/Patients/{patientId}/Episodes",
               defaults: new { controller = "ConsentManagement", action = "Episodes" }
               ).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "ConsentManagement/Hospitals/{hospitalId}/Patients/{patientId}/Episodes/{episodeId}/Withdraw",
               defaults: new { controller = "ConsentManagement", action = "WithdrawEpisode" }
               ).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "ConsentManagement/Hospitals/{hospitalId}/Patients/{patientId}/Episodes/{episodeId}/Reinstate",
               defaults: new { controller = "ConsentManagement", action = "ReinstateEpisode" }
               ).SetTitle(titleMethod);

            // DocumentManagement / RemoveDocument

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.DocumentManagement.DocumentManagementViewModelBase;
                return vm.IsHospitalSelected() ? string.Format("Remove Document at {0}", vm.CurrentHospital.Name) : "Remove Document";
            };

            routes.MapRoute(
                name: string.Empty,
                url: "DocumentManagement/RemoveDocument/Patients",
                defaults: new { controller = "DocumentManagement", action = "Patients" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
              name: string.Empty,
              url: "DocumentManagement/RemoveDocument/Hospitals/{hospitalId}/Patients/{patientId}/Documents",
              defaults: new { controller = "DocumentManagement", action = "Documents" }
              ).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "DocumentManagement/RemoveDocument/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Remove",
            defaults: new { controller = "DocumentManagement", action = "RemoveDocument" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "DocumentManagement/RemoveDocument/Hospitals/{hospitalId}/Patients/Lookup",
               defaults: new { controller = "DocumentManagement", action = "LookupMrnForRemoveDocument" }
               ).SetTitle(titleMethod);

            /* Uploaded Document Rendered */
            routes.MapRoute(
                name: string.Empty,
                url: "DocumentManagement/RemoveDocument/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content/View/{filename}",
                defaults: new { controller = "DocumentManagement", action = "DocumentContentView" }
                ).SetTitle(titleMethod);

            /* Uploaded Document IFrame Wrapper */
            routes.MapRoute(
                name: string.Empty,
                url: "DocumentManagement/RemoveDocument/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content",
                defaults: new { controller = "DocumentManagement", action = "DocumentContent" }
                ).SetTitle(titleMethod);

            /* Uploaded Document Wrapper, Header etc. */
            routes.MapRoute(
                name: "RemoveDocument-Document",
                url: "DocumentManagement/RemoveDocument/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}",
                defaults: new { controller = "DocumentManagement", action = "Document" }
                ).SetTitle(titleMethod);

            // DocumentUpload
            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.DocumentUpload.DocumentUploadViewModelBase;
                return vm.IsHospitalSelected() ? string.Format("Discharge Summary - Patients at {0}", vm.CurrentHospital.Name) : "Discharge Summary - Patients";
            };

            routes.MapRoute(
                name: string.Empty,
                url: "DocumentUpload/Patients",
                defaults: new { controller = "DocumentUpload", action = "Patients" }).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "DocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content/View/{filename}",
               defaults: new { controller = "DocumentUpload", action = "DocumentContentView" });

            routes.MapRoute(
                name: string.Empty,
                url: "DocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content",
                defaults: new { controller = "DocumentUpload", action = "DocumentContent" });

            routes.MapRoute(
               name: string.Empty,
               url: "DocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes/{episodeId}/Documents/{setId}/Supersede",
               defaults: new { controller = "DocumentUpload", action = "UploadOrSupersede" });

            routes.MapRoute(
               name: string.Empty,
               url: "DocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes/{episodeId}/Upload",
               defaults: new { controller = "DocumentUpload", action = "UploadOrSupersede" });

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.DocumentUpload.DocumentUploadViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Discharge Summary - Episodes for {0}", vm.CurrentPatient.Name) : "Discharge Summary - Episodes";
            };

            routes.MapRoute(
                name: string.Empty,
                url: "DocumentUpload/Hospitals/{hospitalId}/Patients/Lookup",
                defaults: new { controller = "DocumentUpload", action = "LookupMrn" }).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "DocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes",
                defaults: new { controller = "DocumentUpload", action = "Episodes" }).SetTitle(titleMethod);

            // Embedded Document Upload
            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content",
                defaults: new { controller = "DocumentUpload", action = "DocumentContent" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content/View/{filename}",
                defaults: new { controller = "DocumentUpload", action = "DocumentContentView" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content",
                defaults: new { controller = "DocumentUpload", action = "DocumentContent" });

            routes.MapRoute(
               name: string.Empty,
               url: "EmbeddedDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes/{episodeId}/Documents/{setId}/Supersede",
               defaults: new { controller = "DocumentUpload", action = "UploadOrSupersede" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes/{episodeId}/Upload",
                defaults: new { controller = "DocumentUpload", action = "UploadOrSupersede" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes",
                defaults: new { controller = "DocumentUpload", action = "Episodes" }).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedDocumentUpload/ViewDocument",
                defaults: new { controller = "DocumentUpload", action = "ViewDocument" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedDocumentUpload/UploadOrSupersede",
                defaults: new { controller = "DocumentUpload", action = "UploadOrSupersede" });

            // Embedded Enterprise Document Upload
            routes.MapRoute(
                name: string.Empty,
               url: "EmbeddedEnterpriseDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content",
               defaults: new { controller = "DocumentUpload", action = "DocumentContent" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterpriseDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content/View/{filename}",
                defaults: new { controller = "DocumentUpload", action = "DocumentContentView" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterpriseDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{setId}/Content",
                defaults: new { controller = "DocumentUpload", action = "DocumentContent" });

            routes.MapRoute(
               name: string.Empty,
               url: "EmbeddedEnterpriseDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes/{episodeId}/Documents/{setId}/Supersede",
               defaults: new { controller = "DocumentUpload", action = "UploadOrSupersede" });

            routes.MapRoute(
               name: string.Empty,
               url: "EmbeddedEnterpriseDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/{statePatientId}/Episodes/{episodeId}/Upload",
               defaults: new { controller = "DocumentUpload", action = "UploadOrSupersede" });

            routes.MapRoute(
               name: string.Empty,
               url: "EmbeddedEnterpriseDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes/{episodeId}/Upload",
               defaults: new { controller = "DocumentUpload", action = "UploadOrSupersede" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterpriseDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/Episodes",
                defaults: new { controller = "DocumentUpload", action = "EmbeddedEnterpriseEpisodes" }).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterpriseDocumentUpload/Hospitals/{hospitalId}/Patients/{patientId}/{statePatientId}/Episodes",
                defaults: new { controller = "DocumentUpload", action = "EmbeddedEnterpriseEpisodes" }).SetTitle(titleMethod);

            // HPI-I Validation
            titleMethod = (m) =>
            {
                return "HPI-I Validation";
            };

            routes.MapRoute(
               name: string.Empty,
               url: "HpiiSearch/SearchById",
               defaults: new { controller = "HpiiSearch", action = "SearchById" })
               .SetTitle(titleMethod);

            // HPI-I search
            titleMethod = (m) =>
            {
                return "HPI-I Search";
            };

            routes.MapRoute(
              name: string.Empty,
              url: "HpiiSearch/SearchByDemographics",
              defaults: new { controller = "HpiiSearch", action = "SearchByDemographics" })
              .SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "HpiiSearch/Providers",
                defaults: new { controller = "HpiiSearch", action = "Providers" }).SetTitle("Local Providers");

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.HpiiSearch.LocalProviderViewModelBase;
                return string.Format("New Provider for {0}", vm.CurrentHospital.Name);
            };

            routes.MapRoute(
                name: string.Empty,
                url: "HpiiSearch/Providers/AddProvider",
                defaults: new { controller = "HpiiSearch", action = "AddProvider" }).SetTitle(titleMethod);

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.HpiiSearch.LocalProviderViewModelBase;
                return string.Format("Edit Provider for {0}", vm.CurrentHospital.Name);
            };

            routes.MapRoute(
                name: string.Empty,
                url: "HpiiSearch/Providers/{localProviderCode}/EditProvider",
                defaults: new { controller = "HpiiSearch", action = "EditProvider" }).SetTitle(titleMethod);

            // AssistedRegistration
            titleMethod = (m) =>
            {
                return "Register Current Patients";
            };

            routes.MapRoute(
               name: string.Empty,
               url: "AssistedRegistration/Unregistered",
               defaults: new { controller = "AssistedRegistration", action = "Unregistered" }).SetTitle(titleMethod);

            routes.MapRoute(
               name: string.Empty,
               url: "AssistedRegistration/Hospitals/{hospitalId}/Register",
               defaults: new { controller = "AssistedRegistration", action = "Register" });

            routes.MapRoute(
               name: string.Empty,
               url: "AssistedRegistration/Hospitals/{hospitalId}/RegisterDependant",
               defaults: new { controller = "AssistedRegistration", action = "RegisterDependant" });

            // Embedded Assisted Registration
            routes.MapRoute(
               name: string.Empty,
               url: "EmbeddedAssistedRegistration/Hospitals/{hospitalId}/Patients/{patientId}/Register",
               defaults: new { controller = "AssistedRegistration", action = "Register" });

            routes.MapRoute(
               name: string.Empty,
               url: "EmbeddedAssistedRegistration/Hospitals/{hospitalId}/Register",
               defaults: new { controller = "AssistedRegistration", action = "Register" });

            routes.MapRoute(
               name: string.Empty,
               url: "EmbeddedAssistedRegistration/Hospitals/{hospitalId}/Patients/{patientId}/RegisterDependant",
               defaults: new { controller = "AssistedRegistration", action = "RegisterDependant" });

            routes.MapRoute(
               name: string.Empty,
               url: "EmbeddedAssistedRegistration/Hospitals/{hospitalId}/RegisterDependant",
               defaults: new { controller = "AssistedRegistration", action = "RegisterDependant" });

            // Embedded Enterprise Assisted Registration
            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterpriseAssistedRegistration/Hospitals/{hospitalId}/Patients/{patientId}/Register",
                defaults: new { controller = "AssistedRegistration", action = "EmbeddedEnterpriseRegister" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterpriseAssistedRegistration/Hospitals/{hospitalId}/Patients/{patientId}/{statePatientId}/Register",
                defaults: new { controller = "AssistedRegistration", action = "EmbeddedEnterpriseRegister" });

            routes.MapRoute(
                name: string.Empty,
              url: "EmbeddedEnterpriseAssistedRegistration/Hospitals/{hospitalId}/Patients/{patientId}/RegisterDependant",
              defaults: new { controller = "AssistedRegistration", action = "EmbeddedEnterpriseRegisterDependant" });

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterpriseAssistedRegistration/Hospitals/{hospitalId}/Patients/{patientId}/{statePatientId}/RegisterDependant",
                defaults: new { controller = "AssistedRegistration", action = "EmbeddedEnterpriseRegisterDependant" });

            // Patient Landing Page (Embedded PCEHR View):

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Prescription and Dispense View for {0}", vm.CurrentPatient.Name) : string.Empty;
            };

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedPcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView/Content/View",
                defaults: new { controller = "PcehrView", action = "PrescriptionDispenseViewContentView" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedPcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView/Content",
                defaults: new { controller = "PcehrView", action = "PrescriptionDispenseViewContent" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedPcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PrescriptionDispenseView",
                defaults: new { controller = "PcehrView", action = "PrescriptionDispenseView" }
                ).SetTitle(titleMethod);

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return string.Format("{0} for {1}", vm.CurrentDocument.CategoryName, vm.CurrentPatient.Name);
            };

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedPcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}/Content/View/{filename}",
                defaults: new { controller = "PcehrView", action = "DocumentContentView" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedPcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}/Content",
                defaults: new { controller = "PcehrView", action = "DocumentContent" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
                name: "EmbeddedPcehrView-Document",
                url: "EmbeddedPcehrView/Hospitals/{hospitalId}/Patients/{patientId}/Documents/{repositoryId}/{documentId}",
                defaults: new { controller = "PcehrView", action = "Document" }
                ).SetTitle(titleMethod);

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Patient Summary for {0}", vm.CurrentPatient.Name) : "Patient Summary";
            };

            // Embedded Enterprise PcehrView

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterprisePcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PatientSummary",
                defaults: new { controller = "PcehrView", action = "EnterprisePatientSummary" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedEnterprisePcehrView/Hospitals/{hospitalId}/Patients/{patientId}/{statePatientId}/PatientSummary",
                defaults: new { controller = "PcehrView", action = "EnterprisePatientSummary" }
                ).SetTitle(titleMethod);

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedPcehrView/Hospitals/{hospitalId}/Patients/{patientId}/PatientSummary",
                defaults: new { controller = "PcehrView", action = "PatientSummary" }
                ).SetTitle(titleMethod);

            titleMethod = (m) =>
            {
                var vm = m as HIPS.Web.UI.ViewModels.PcehrView.PcehrViewModelBase;
                return vm.IsPatientSelected() ? string.Format("Gain Access for {0}", vm.CurrentPatient.Name) : string.Empty;
            };

            routes.MapRoute(
                name: string.Empty,
                url: "EmbeddedPcehrView/Hospitals/{hospitalId}/Patients/{patientId}/GainAccess",
                defaults: new { controller = "PcehrView", action = "EmbeddedGainAccess" }).SetTitle(titleMethod);

            // Generic routes:

            routes.MapRoute(
                name: "Default",
                url: "{controller}/{action}/{id}",
                defaults: new { controller = "Home", action = "Index", id = UrlParameter.Optional });
        }
    }
}