﻿using System.Web.Mvc;

namespace HIPS.Web.UI.Areas.Directory
{
    /// <summary>
    /// Registration class for directory area.
    /// </summary>
    public class DirectoryAreaRegistration : AreaRegistration
    {
        #region Properties

        /// <summary>
        /// Gets the name of the area.
        /// </summary>
        public override string AreaName
        {
            get
            {
                return "Directory";
            }
        }

        #endregion

        #region Methods

        /// <summary>
        /// Register the area.
        /// </summary>
        /// <param name="context">AreaRegistrationContext to use for registration of the area.</param>
        public override void RegisterArea(AreaRegistrationContext context)
        {
            // Payload Schemes
            context.MapRoute(
                name: string.Empty,
                url: "Directory/DirectoryMaintenance/{controller}/{action}",
                defaults: new { action = "Index" });

            // Generic routes
            context.MapRoute(
                "Directory_default",
                "Directory/{controller}/{action}/{id}",
                new { action = "Index", id = UrlParameter.Optional });
        }

        #endregion
    }
}