﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;

using HIPS.Web.Model.Directory;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Directory.ViewModels
{
    /// <summary>
    /// Activate payload scheme view model.
    /// </summary>
    public class ActivatePayloadSchemeViewModel : DirectoryViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="ActivatePayloadSchemeViewModel"/> class.
        /// </summary>
        public ActivatePayloadSchemeViewModel()
            : base()
        {

        }

        #endregion
        
        #region Properties

        /// <summary>
        /// Gets or sets the qualified identifier of the payload scheme to be activated or deactivated.
        /// </summary>
        [Required]
        [Display(Name = "Qualified Identifier")]
        public string QualifiedIdentifier { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether to activate (true) or deactivate (false) the payload scheme.
        /// </summary>
        [Required]
        [Display(Name = "Is Active")]
        public bool IsActive { get; set; }

        #endregion        
    }
}