﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace HIPS.Web.UI.Areas.Messaging.ViewModels
{
    /// <summary>
    /// View model for displaying the details of sealed message.
    /// </summary>
    public class DetailsViewModel
    {
        /// <summary>
        /// Gets or sets Creation Time.
        /// </summary>
        [Display(Name = "Created")]
        public DateTime CreationTime { get; set; }

        /// <summary>
        /// Gets or sets Sender Organisation.
        /// </summary>
        [Display(Name = "Sender Organisation")]
        public string SenderOrganisation { get; set; }

        /// <summary>
        /// Gets or sets Receiver Organisation.
        /// </summary>
        [Display(Name = "Receiver Organisation")]
        public string ReceiverOrganisation { get; set; }

        /// <summary>
        /// Gets or sets Sender Individual.
        /// </summary>
        [Display(Name = "Sender Individual")]
        public string SenderIndividual { get; set; }

        /// <summary>
        /// Gets or sets Receiver Individual.
        /// </summary>
        [Display(Name = "Receiver Individual")]
        public string ReceiverIndividual { get; set; }

        /// <summary>
        /// Gets or sets Payload Scheme.
        /// </summary>
        [Display(Name = "Payload Scheme")]
        public string PayloadScheme { get; set; }
        
        /// <summary>
        /// Gets or sets the set of transport responses.
        /// </summary>
        public List<TransportResponseViewModel> TransportResponses { get; set; }

        /// <summary>
        /// Gets or sets the subject of care.
        /// </summary>
        [Display(Name = "Subject of Care")]
        public string SubjectOfCare { get; set; }
    }
}