﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

using HIPS.Web.Model;

namespace HIPS.Web.UI.Areas.Messaging.ViewModels
{
    /// <summary>
    /// View model for displaying Transport responses.
    /// </summary>
    public class TransportResponseViewModel
    {
        /// <summary>
        /// Gets or sets the Response Time.
        /// </summary>
        [Display(Name = "Response Time")]
        public DateTime ResponseTime { get; set; }

        /// <summary>
        /// Gets or sets the Response Class.
        /// </summary>
        [Display(Name = "Response Class")]
        public TransportResponseClass ResponseClass { get; set; }

        /// <summary>
        /// Gets or sets the Response Status.
        /// </summary>
        [Display(Name = "Response Status")]
        public TransportResponseStatus ResponseStatus { get; set; }

        /// <summary>
        /// Gets or sets the Response Message.
        /// </summary>
        [Display(Name = "Response Message")]
        public string ResponseMessage { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether Final is true or false.
        /// </summary>
        [Display(Name = "Final")]
        public bool Final { get; set; }
    }
}