﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Areas.Subscription.ViewModels
{
    public class ExtraOrganisationSearchViewModel
    {
        #region Properties

        /// <summary>
        /// Gets or sets Organisation Name.
        /// </summary>
        [Display(Name = "Name")]
        public string OrganisationName { get; set; }

        /// <summary>
        /// Gets or sets the Classification.
        /// </summary>
        public string Classification { get; set; }

        /// <summary>
        /// Gets or sets the Classification list for the dropdown.
        /// </summary>
        public IEnumerable<SelectListItem> ClassificationList { get; set; }

        /// <summary>
        /// Gets or sets the Suburb.
        /// </summary>
        [Display(Name = "Suburb")]
        public string OrgSuburb { get; set; }

        /// <summary>
        /// Gets or sets the State.
        /// </summary>
        [Display(Name = "State")]
        public string OrgState { get; set; }

        /// <summary>
        /// Gets or sets the State List for the dropdown.
        /// </summary>
        public IEnumerable<SelectListItem> OrgStateList { get; set; }

        /// <summary>
        /// Gets or sets the Postcode.
        /// </summary>
        [Display(Name = "Postcode")]
        public string OrgPostcode { get; set; }

        /// <summary>
        /// Gets or sets the ProximityRadius.
        /// </summary>
        [Display(Name = "Proximity Radius")]
        public int OrgProximityRadius { get; set; }

        /// <summary>
        /// Gets or sets the ProximityRadius List for the dropdown.
        /// </summary>
        public IEnumerable<SelectListItem> OrgProximityRadiusList { get; set; }

        /// <summary>
        /// Gets or sets the URI allocated by NEPS to identify this area of interest definition.
        /// </summary>
        public string OrgCode { get; set; }

        #endregion
    }
}