﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.Web.UI.Helpers.Mapping.Context
{
    /// <summary>
    /// Provides context used when mapping local providers.
    /// </summary>
    public class LocalProviderMappingContext
    {
        #region Constructors
        
        /// <summary>
        /// Initialises a new instance of the <see cref="LocalProviderMappingContext"/> class.
        /// </summary>
        /// <param name="hospitalCode">Hospital Code.</param>
        /// <param name="hospitalCodeSystem">Hospital Code System.</param>
        public LocalProviderMappingContext(string hospitalCode, string hospitalCodeSystem)
        {
            this.HospitalCode = hospitalCode;
            this.HospitalCodeSystem = hospitalCodeSystem;
        }
        
        #endregion

        #region Properties

        /// <summary>
        /// Gets the Hospital code.
        /// </summary>
        public string HospitalCode { get; private set; }

        /// <summary>
        /// Gets the Hospital Code System.
        /// </summary>
        public string HospitalCodeSystem { get; private set; }

        #endregion
    }
}
