﻿using AutoMapper;
using HIPS.Web.Components.ServiceModel;
using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.Helpers.Mapping.Profiles
{
    /// <summary>
    /// AutoMapper mapping profile for the Message entity.
    /// </summary>
    internal class MessageProfile : Profile
    {
        /// <summary>
        /// Returns the name of the mapping profile.
        /// </summary>
        public override string ProfileName
        {
            get { return this.GetType().Name; }
        }

        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // Data --> ViewModel:
            this.CreateMap<ResponseMessage, ViewMessage>()
                .ForMember(dest => dest.Description, opt => opt.MapFrom(src => src.Description))
                .ForMember(dest => dest.Level, opt => opt.MapFrom(src => src.Level));
        }

        #endregion Methods
    }
}