﻿using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

using HIPS.Web.UI.ViewModels.Shared;

namespace HIPS.Web.UI.ViewModels.Common
{
    /// <summary>
    /// View model for the "Select Health Provider Organisation" action.
    /// </summary>
    public class SelectHpoViewModel
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="SelectHpoViewModel"/> class.
        /// </summary>
        public SelectHpoViewModel()
        {
            this.Messages = new ViewMessageList();
            this.Hospitals = Enumerable.Empty<SelectListItem>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets the list of messages associated with the view model.
        /// </summary>
        public ViewMessageList Messages { get; set; }

        /// <summary>
        /// Gets or sets the currently selected health provider organisation.
        /// </summary>
        [Display(Name = "Health Provider Organisation")]
        public string SelectedHospitalCode { get; set; }

        /// <summary>
        /// Gets or sets the return URL.
        /// </summary>
        [Required]
        [Display(Name = "Return URL")]
        public string ReturnUrl { get; set; }

        /// <summary>
        /// Gets or sets the list of health provider organisations available for selection.
        /// </summary>
        public IEnumerable<SelectListItem> Hospitals { get; set; }

        #endregion Properties
    }
}