﻿using System.Collections.Generic;

namespace HIPS.Web.UI.ViewModels.ConsentManagement
{
    /// <summary>
    /// View model containing a list of episodes, for the user to select an episode, to withdraw or reinstate consent to upload documents.
    /// </summary>
    public class PatientEpisodesViewModel : ConsentManagementViewModelBase
    {
        #region Constructors

        /// <summary>
        /// Initialises a new instance of the <see cref="PatientEpisodesViewModel" /> class.
        /// </summary>
        public PatientEpisodesViewModel()
        {
            this.PatientEpisodes = new List<EpisodeViewModel>();
        }

        #endregion Constructors

        #region Properties

        /// <summary>
        /// Gets or sets a list of episodes from which the user may select one.
        /// </summary>
        public List<EpisodeViewModel> PatientEpisodes { get; set; }

        #endregion Properties
    }
}