﻿using HIPS.Web.UI.ViewModels.Shared;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

namespace HIPS.Web.UI.ViewModels.DisclosureManagement
{
    /// <summary>
    /// View model for Register Patient.
    /// </summary>
    public class RegisterPatientViewModel
    {
        /// <summary>
        /// Gets or sets the list of messages associated with the view model.
        /// </summary>        
        public ViewMessageList Messages { get; set; }

        /// <summary>
        /// Gets or sets Family Name.
        /// </summary>
        [Display(Name = "Family Name*")]
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets Family Name.
        /// </summary>
        [Display(Name = "Given Name(s)")]
        public string GivenName { get; set; }

        /// <summary>
        /// Gets or sets Sex code.
        /// </summary>
        [Required]
        [Display(Name = "Sex")]
        public string SexCode { get; set; }

        /// <summary>
        /// Gets or sets Sex drop down.
        /// </summary>
        public IEnumerable<SelectListItem> Sexes { get; set; }

        /// <summary>
        /// Gets or sets the date of birth of the patient.
        /// </summary>
        [DisplayFormat(DataFormatString = "dd/MM/yyyy")]
        [Display(Name = "Date of Birth*")]
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets Medicare Number of the patient.
        /// </summary>
        [Display(Name = "Medicare Card Number")]
        public string MedicareNumber { get; set; }

        /// <summary>
        /// Gets or sets IRN of the patient.
        /// </summary>
        [Display(Name = "IRN")]
        public string MedicareNumberIrn { get; set; }

        /// <summary>
        /// Gets or sets DVA Number of the patient.
        /// </summary>
        [Display(Name = "DVA File Number")]
        public string DvaFileNumber { get; set; }

        /// <summary>
        /// Gets or sets the MRN of the patient.
        /// </summary>
        [Display(Name = "MRN*")]
        public string Mrn { get; set; }
    }
}