﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.Web.Model;

namespace HIPS.Web.UI.ViewModels.HpiiSearch
{
    /// <summary>
    /// View model for Local Provider.
    /// </summary>
    public class LocalProviderViewModel
    {
        /// <summary>
        /// Gets or sets the Full name.
        /// </summary>
        public string FullName { get; set; }
        
        /// <summary>
        /// Gets or sets the Local Identifier.
        /// </summary>
        public string LocalIdentifier { get; set; }
        
        /// <summary>
        /// Gets or sets the HPI-I.
        /// </summary>
        public string Hpii { get; set; }
        
        /// <summary>
        /// Gets or sets the HPI-I Status.
        /// </summary>
        public HpiiStatus HpiiStatus { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the local provider is active or inactive.
        /// </summary>
        public bool Active { get; set; }

        public string LocalProviderCode { get; set; }
        
        /// <summary>
        /// Gets the Local Provider Status.
        /// </summary>
        public string LocalProviderStatus
        {
            get { return this.Active ? "Active" : "Inactive"; }
        }
    }
}
