﻿using AutoMapper;
using HIPS.AppServer.ServiceHost.Utility;
using HIPS.PcehrDataStore.Schemas;
using HIPS.ServiceContracts.Common;
using HIPS.ServiceContracts.Hpii.DTO;
using HIPS.ServiceContracts.Hpii.Message;
using System;

namespace HIPS.AppServer.HIPSServiceHost.Mapping.Profiles
{
    public class LocalProviderProfile : Profile
    {
        #region Methods

        /// <summary>
        /// Configures the maps available as part of this mapping profile.
        /// </summary>
        protected override void Configure()
        {
            // HealthProviderIndividual -> LocalProviderResponse
            this.CreateMap<HealthProviderIndividual, LocalProvider>()
                .ForMember(dest => dest.FamilyName, opt => opt.MapFrom(src => src.FamilyName))
                .ForMember(dest => dest.GivenNames, opt => opt.MapFrom(src => src.GivenNames))
                .ForMember(dest => dest.Title, opt => opt.MapFrom(src => src.Title))
                .ForMember(dest => dest.Suffix, opt => opt.MapFrom(src => src.Suffix))
                .ForMember(dest => dest.HpiiStatus, opt => opt.ResolveUsing<HpiiStatusResolver>().FromMember(src => src.HpiiStatusId))
                .ForMember(dest => dest.Active, opt => opt.ResolveUsing<LocalProviderStatusResolver>().FromMember(src => src.DeactivatedDate));

            // HospitalHealthProviderIndividual -> LocalProviderIdentifier
            this.CreateMap<HospitalHealthProviderIndividual, LocalProviderIdentifier>();
        }

        /// <summary>
        /// Resolves the value of the HpiiStatus
        /// </summary>
        internal class HpiiStatusResolver : ValueResolver<int?, HpiiStatus>
        {
            #region Methods

            /// <summary>
            /// Resolve the required value.
            /// </summary>
            /// <param name="source">ResolutionResult representing the source.</param>
            /// <returns>ResolutionResult representing the destination.</returns>
            protected override HpiiStatus ResolveCore(int? source)
            {

                if (source == 1)
                {
                    return HpiiStatus.Active;
                }
                else if (source == 2)
                {
                    return HpiiStatus.Deactivated;
                }
                else if (source == 3)
                {
                    return HpiiStatus.Retired;
                }
                else
                {
                    return HpiiStatus.Undefined;
                }
            }

            #endregion Methods
        }

        /// <summary>
        /// Resolves the value of the LocalProviderStatus
        /// </summary>
        internal class LocalProviderStatusResolver : ValueResolver<DateTime?, bool>
        {
            /// <summary>
            /// Resolve the required value.
            /// </summary>
            /// <param name="source">ResolutionResult representing the source.</param>
            /// <returns>ResolutionResult representing the destination.</returns>
            protected override bool ResolveCore(DateTime? source)
            {
                if (source.HasValue)
                {
                    if (source.Value <= DateTime.Now)
                    {
                        return false;
                    }
                }

                return true;
            }
        }


        #endregion Methods
    }
}
