﻿#region Using Directives

using System.Collections.Generic;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;

#endregion Using Directives

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class AssistedRegistrationProxy : ClientBase<IAssistedRegistrationService>, IAssistedRegistrationService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public AssistedRegistrationProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Lists the current patients stored in the local PCEHR Data Store without a Digital Health Record.
        /// </summary>
        /// <param name="hospitalCodeSystem">The hospital code system.</param>
        /// <param name="hospitalCode">The hospital code.</param>
        /// <returns>List of patients without a PCEHR</returns>
        public PatientWithoutPcehrResponse ListPatientsWithoutPcehr(string hospitalCodeSystem, string hospitalCode = null)
        {
            return Channel.ListPatientsWithoutPcehr(hospitalCodeSystem, hospitalCode);
        }

        /// <summary>
        /// Registers the dependant for a Digital Health Record with the PCEHR Service.
        /// </summary>
        /// <param name="patientIdentifier">Patient identifier (Hospital-level MRN, State Patient ID, Validated IHI or PCEHR Data Store PatientMasterId)</param>
        /// <param name="representativeDemographics">The representative demographics.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns>PCEHR Registration Response object.</returns>
        public PcehrRegistrationResponse RegisterDependant(PatientIdentifierBase patientIdentifier, Demographic representativeDemographics, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, bool representativeDeclaration, UserDetails user, Attachment consentForm = null)
        {
            return Channel.RegisterDependant(patientIdentifier, representativeDemographics, identityType, indigenousStatus, documentConsent, correspondenceChannel, acceptedTermsAndConditions, representativeDeclaration, user, consentForm);
        }

        /// <summary>
        /// Registers the patient for a Digital Health Record with the PCEHR Service.
        /// </summary>
        /// <param name="patientIdentifier">Patient identifier (Hospital-level MRN, State Patient ID, Validated IHI or PCEHR Data Store PatientMasterId)</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns>PCEHR Registration Response object.</returns>
        public PcehrRegistrationResponse RegisterPatient(PatientIdentifierBase patientIdentifier, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, UserDetails user, Attachment consentForm = null)
        {
            return Channel.RegisterPatient(patientIdentifier, identityType, indigenousStatus, documentConsent, correspondenceChannel, acceptedTermsAndConditions, user, consentForm);
        }

        /// <summary>
        /// Reregisters the dependant for a Digital Health Record with the PCEHR Service.
        /// </summary>
        /// <param name="patientMasterId">The patient master identifier.</param>
        /// <param name="patientIdentifier">Patient identifier (Hospital-level MRN, State Patient ID, Validated IHI or PCEHR Data Store PatientMasterId)</param>
        /// <param name="representativeDemographics">The representative demographics.</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns>PCEHR Registration Response object.</returns>
        public PcehrRegistrationResponse ReregisterDependant(int patientMasterId, PatientIdentifierBase patientIdentifier, Demographic representativeDemographics, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, bool representativeDeclaration, UserDetails user, Attachment consentForm = null)
        {
            return Channel.ReregisterDependant(patientMasterId, patientIdentifier, representativeDemographics, identityType, indigenousStatus, documentConsent, correspondenceChannel, acceptedTermsAndConditions, representativeDeclaration, user, consentForm);
        }

        /// <summary>
        /// Reregisters the patient for a Digital Health Record with the PCEHR Service.
        /// </summary>
        /// <param name="patientMasterId">The patient master identifier.</param>
        /// <param name="patientIdentifier">Patient identifier (Hospital-level MRN, State Patient ID, Validated IHI or PCEHR Data Store PatientMasterId)</param>
        /// <param name="identityType">Type of the identity.</param>
        /// <param name="indigenousStatus">The indigenous status.</param>
        /// <param name="documentConsent">The document consent.</param>
        /// <param name="correspondenceChannel">The correspondence channel.</param>
        /// <param name="acceptedTermsAndConditions">if set to <c>true</c> [accepted terms and conditions].</param>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <param name="consentForm">The consent form.</param>
        /// <returns>PCEHR Registration Response object.</returns>
        public PcehrRegistrationResponse ReregisterPatient(int patientMasterId, PatientIdentifierBase patientIdentifier, EvidenceOfIdentityType identityType, IndigenousStatus indigenousStatus, List<RegistrationDocumentConsent> documentConsent, RegistrationCorrespondenceChannel correspondenceChannel, bool acceptedTermsAndConditions, UserDetails user, Attachment consentForm = null)
        {
            return Channel.ReregisterPatient(patientMasterId, patientIdentifier, identityType, indigenousStatus, documentConsent, correspondenceChannel, acceptedTermsAndConditions, user, consentForm);
        }
    }
}