﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.BusinessEntities.ResponseEntities;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.Reference.ServiceContracts;

namespace HIPS.Client.Proxy
{
    public class ReferenceProxy : ClientBase<IHIPSReferenceService>, IHIPSReferenceService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public ReferenceProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Find all known information about a hospital, such as:
        /// <list identifier="bullet">
        /// <item>Description and Name</item>
        /// <item>Address</item>
        /// <item>Fax Number</item>
        /// <item>List of Identifiers (HPI-O, OID for MRNs, OID for Provider Identifers, ISAAC)</item>
        /// </list>
        /// </summary>
        /// <param name="identifier">An identifier for the hospital</param>
        /// <param name="codeSystemName">The namespace of the identifier supplied</param>
        /// <returns>The hospital details</returns>
        public HospitalDetailResponse GetHospitalDetails(string hospitalCode, string hospitalCodeSystem)
        {
            return Channel.GetHospitalDetails(hospitalCode, hospitalCodeSystem);
        }

        /// <summary>
        /// Lists the hospitals.
        /// </summary>
        /// <returns>A list of all the hospitals</returns>
        public List<Hospital> ListHospitals()
        {
            return Channel.ListHospitals();
        }

        /// <summary>
        /// Reloads all the reference data from the database.
        /// See <see cref="HIPS.CommonBusinessLogic.Singleton.ListSingleton"/> for
        /// further details of which reference data is loaded.
        /// </summary>
        /// <param name="user">Information to identify the person responsible for this action.</param>
        /// <returns>Indicator of success or failure</returns>
        public HipsResponse ReloadReferenceData(UserDetails user)
        {
            return Channel.ReloadReferenceData(user);
        }
    }
}