﻿namespace HIPS.CommonSchemas.Cda.ParticipatingIndividual
{
    /// <summary>
    /// Participating Individual model. This object contains information that identifies
    /// a participating provider or consumer.
    /// </summary>
    public abstract class ParticipatingIndividual
    {
        #region Properties

        /// <summary>
        /// Gets or sets the family name of the participant.
        /// </summary>
        public string FamilyName { get; set; }

        /// <summary>
        /// Gets or sets the given names of the participant.
        /// If there are multiple given names, they should be separated by spaces.
        /// </summary>
        public string GivenNames { get; set; }

        /// <summary>
        /// Gets or sets the unique local identifier of the participant. The local
        /// identifier must be unique within the participating organisation (HPI-O).
        /// This is conditionally mandatory with the HPI-I as at least one must
        /// be specified.
        /// </summary>
        public string LocalIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the name suffix of the participant.
        /// </summary>
        public string Suffix { get; set; }

        /// <summary>
        /// Gets or sets the name title of the participant.
        /// </summary>
        public string Title { get; set; }

        #endregion Properties
    }
}