﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Store all of the Pathology Test Result Data. 
    /// </summary>
    public class  PathologyTestResult
    {
        /// <summary>
        /// The test result object commn across the PathologyTestResult and ImagingExamResult objects.
        /// </summary>
        public TestResult TestResult { get; set; }
        
        /// <summary>
        /// The Pathology Discipline the test was associated with.
        /// </summary>
        public PathologyDiscipline PathologyDiscipline { get; set; }
        
        /// <summary>
        /// The date and time the Pathology Test was collected.
        /// </summary>
        public DateTime CollectionDateTime { get; set; }    
    }
}
